/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query.derived;

import com.arangodb.springframework.repository.query.derived.geo.Ring;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;

public class BindParameterBinding {
    private final Map<String, Object> bindVars;

    public BindParameterBinding(Map<String, Object> bindVars) {
        this.bindVars = bindVars;
    }

    public int bind(Object value, boolean shouldIgnoreCase, Boolean borderStatus, UniqueCheck uniqueCheck, int startIndex) {
        int index = startIndex;
        Object caseAdjusted = this.ignoreArgumentCase(value, shouldIgnoreCase);
        Class<?> clazz = caseAdjusted.getClass();
        if (clazz == Distance.class) {
            Distance distance = (Distance)caseAdjusted;
            this.bind(index++, this.convertDistanceToMeters(distance));
        } else if (borderStatus != null && borderStatus.booleanValue()) {
            this.bind(index++, this.escapeSpecialCharacters((String)caseAdjusted) + "%");
        } else if (borderStatus != null) {
            this.bind(index++, "%" + this.escapeSpecialCharacters((String)caseAdjusted));
        } else {
            this.bind(index++, caseAdjusted);
        }
        return index;
    }

    public int bindPolygon(Object value, boolean shouldIgnoreCase, int startIndex) {
        int index = startIndex;
        Polygon polygon = (Polygon)this.ignoreArgumentCase(value, shouldIgnoreCase);
        LinkedList points = new LinkedList();
        polygon.forEach(p -> {
            LinkedList<Double> point = new LinkedList<Double>();
            point.add(p.getY());
            point.add(p.getX());
            points.add(point);
        });
        this.bind(index++, points);
        return index;
    }

    public int bindRing(Object value, boolean shouldIgnoreCase, UniqueCheck uniqueCheck, int startIndex) {
        int index = startIndex;
        Ring ring = (Ring)this.ignoreArgumentCase(value, shouldIgnoreCase);
        Point point = ring.getPoint();
        index = this.bindPoint(point, uniqueCheck, index);
        Range range = ring.getRange();
        index = this.bindRange(range, index);
        return index;
    }

    public int bindRange(Object value, boolean shouldIgnoreCase, int startIndex) {
        int index = startIndex;
        Range range = (Range)this.ignoreArgumentCase(value, shouldIgnoreCase);
        return this.bindRange(range, index);
    }

    public int bindBox(Object value, boolean shouldIgnoreCase, int startIndex) {
        int index = startIndex;
        Box box = (Box)this.ignoreArgumentCase(value, shouldIgnoreCase);
        Point first = box.getFirst();
        Point second = box.getSecond();
        double minLatitude = Math.min(first.getY(), second.getY());
        double maxLatitude = Math.max(first.getY(), second.getY());
        double minLongitude = Math.min(first.getX(), second.getX());
        double maxLongitude = Math.max(first.getX(), second.getX());
        this.bind(index++, minLatitude);
        this.bind(index++, maxLatitude);
        this.bind(index++, minLongitude);
        this.bind(index++, maxLongitude);
        return index;
    }

    public int bindPoint(Object value, boolean shouldIgnoreCase, UniqueCheck uniqueCheck, int startIndex) {
        return this.bindPoint((Point)this.ignoreArgumentCase(value, shouldIgnoreCase), uniqueCheck, startIndex);
    }

    private int bindPoint(Point point, UniqueCheck uniqueCheck, int startIndex) {
        uniqueCheck.check(point);
        int index = startIndex;
        this.bind(index++, point.getY());
        this.bind(index++, point.getX());
        return index;
    }

    public int bindCircle(Object value, boolean shouldIgnoreCase, UniqueCheck uniqueCheck, int startIndex) {
        int index = startIndex;
        Circle circle = (Circle)this.ignoreArgumentCase(value, shouldIgnoreCase);
        Point center = circle.getCenter();
        uniqueCheck.check(center);
        this.bind(index++, center.getY());
        this.bind(index++, center.getX());
        this.bind(index++, this.convertDistanceToMeters(circle.getRadius()));
        return index;
    }

    private int bindRange(Range<?> range, int index) {
        Object lowerBound = range.getLowerBound().getValue().get();
        Object upperBound = range.getUpperBound().getValue().get();
        if (lowerBound.getClass() == Distance.class && upperBound.getClass() == lowerBound.getClass()) {
            lowerBound = this.convertDistanceToMeters((Distance)lowerBound);
            upperBound = this.convertDistanceToMeters((Distance)upperBound);
        }
        this.bind(index++, lowerBound);
        this.bind(index++, upperBound);
        return index;
    }

    private void bind(int index, Object value) {
        this.bindVars.put(Integer.toString(index), value);
    }

    private double convertDistanceToMeters(Distance distance) {
        return distance.getNormalizedValue() * Metrics.KILOMETERS.getMultiplier() * 1000.0;
    }

    private String escapeSpecialCharacters(String string) {
        StringBuilder escaped = new StringBuilder();
        for (char character : string.toCharArray()) {
            if (character == '%' || character == '_' || character == '\\') {
                escaped.append('\\');
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    private Object ignoreArgumentCase(Object argument, boolean shouldIgnoreCase) {
        if (!shouldIgnoreCase) {
            return argument;
        }
        if (argument instanceof String) {
            return ((String)argument).toLowerCase();
        }
        LinkedList<String> lowered = new LinkedList<String>();
        if (argument.getClass().isArray()) {
            String[] array;
            for (String string : array = (String[])argument) {
                lowered.add(string.toLowerCase());
            }
        } else {
            Iterable iterable = (Iterable)argument;
            for (Object object : iterable) {
                lowered.add(((String)object).toLowerCase());
            }
        }
        return lowered;
    }

    static interface UniqueCheck {
        public void check(Point var1);
    }
}

