/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.model.EdgeCollectionDropOptions;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoEdgeCollectionImpl
extends InternalArangoEdgeCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoGraphImpl, ArangoExecutorSync>
implements ArangoEdgeCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoEdgeCollectionImpl.class);

    protected ArangoEdgeCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public void drop() {
        this.drop(new EdgeCollectionDropOptions());
    }

    @Override
    public void drop(EdgeCollectionDropOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.removeEdgeDefinitionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public EdgeEntity insertEdge(Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer());
    }

    @Override
    public EdgeEntity insertEdge(Object value, EdgeCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer());
    }

    @Override
    public <T> T getEdge(String key, Class<T> type) {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, new GraphDocumentReadOptions()), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getEdge(String key, Class<T> type, GraphDocumentReadOptions options) {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public EdgeUpdateEntity replaceEdge(String key, Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity replaceEdge(String key, Object value, EdgeReplaceOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity updateEdge(String key, Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer());
    }

    @Override
    public EdgeUpdateEntity updateEdge(String key, Object value, EdgeUpdateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer());
    }

    @Override
    public void deleteEdge(String key) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteEdge(String key, EdgeDeleteOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

