/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import java.io.IOException;
import java.lang.reflect.Type;

public class ArangoExecutorSync
extends ArangoExecutor {
    private final CommunicationProtocol protocol;

    public ArangoExecutorSync(CommunicationProtocol protocol, ArangoConfig config) {
        super(config);
        this.protocol = protocol;
    }

    public <T> T execute(InternalRequest request, Type type) {
        return this.execute(request, type, null);
    }

    public <T> T execute(InternalRequest request, Type type, HostHandle hostHandle) {
        return (T)this.execute(request, (InternalResponse response) -> this.createResult(type, response), hostHandle);
    }

    public <T> T execute(InternalRequest request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer) {
        return this.execute(request, responseDeserializer, null);
    }

    public <T> T execute(InternalRequest request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) {
        InternalResponse response = this.protocol.execute(this.interceptRequest(request), hostHandle);
        this.interceptResponse(response);
        return responseDeserializer.deserialize(response);
    }

    public void disconnect() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    public void setJwt(String jwt) {
        this.protocol.setJwt(jwt);
    }
}

