/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCollectionDropOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoVertexCollectionImpl
extends InternalArangoVertexCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoGraphImpl, ArangoExecutorSync>
implements ArangoVertexCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoVertexCollectionImpl.class);

    protected ArangoVertexCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public void drop() {
        this.drop(new VertexCollectionDropOptions());
    }

    @Override
    public void drop(VertexCollectionDropOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public VertexEntity insertVertex(Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer());
    }

    @Override
    public VertexEntity insertVertex(Object value, VertexCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer());
    }

    @Override
    public <T> T getVertex(String key, Class<T> type) {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, new GraphDocumentReadOptions()), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getVertex(String key, Class<T> type, GraphDocumentReadOptions options) {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public VertexUpdateEntity replaceVertex(String key, Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity replaceVertex(String key, Object value, VertexReplaceOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity updateVertex(String key, Object value) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity updateVertex(String key, Object value, VertexUpdateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer());
    }

    @Override
    public void deleteVertex(String key) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteVertex(String key, VertexDeleteOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

