/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.RequestType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class InternalRequest {
    private final String dbName;
    private final RequestType requestType;
    private final String path;
    private final Map<String, String> queryParam;
    private final Map<String, String> headerParam;
    private int version = 1;
    private int type = 1;
    private byte[] body;

    public InternalRequest(String dbName, RequestType requestType, String path) {
        this.dbName = dbName;
        this.requestType = requestType;
        this.path = path;
        this.body = null;
        this.queryParam = new HashMap<String, String>();
        this.headerParam = new HashMap<String, String>();
    }

    public int getVersion() {
        return this.version;
    }

    public InternalRequest setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public InternalRequest setType(int type) {
        this.type = type;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getQueryParam() {
        return this.queryParam;
    }

    public InternalRequest putQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParam.put(key, value.toString());
        }
        return this;
    }

    public InternalRequest putQueryParams(Map<String, String> params) {
        if (params != null) {
            for (Map.Entry<String, String> it : params.entrySet()) {
                this.putQueryParam(it.getKey(), it.getValue());
            }
        }
        return this;
    }

    public Map<String, String> getHeaderParam() {
        return Collections.unmodifiableMap(this.headerParam);
    }

    public boolean containsHeaderParam(String key) {
        return this.headerParam.containsKey(key.toLowerCase(Locale.ROOT));
    }

    public InternalRequest putHeaderParam(String key, String value) {
        if (value != null) {
            this.headerParam.put(key.toLowerCase(Locale.ROOT), value);
        }
        return this;
    }

    public InternalRequest putHeaderParams(Map<String, String> params) {
        if (params != null) {
            for (Map.Entry<String, String> it : params.entrySet()) {
                this.putHeaderParam(it.getKey(), it.getValue());
            }
        }
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public InternalRequest setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public String toString() {
        return "{requestType=" + (Object)((Object)this.requestType) + ", database='" + this.dbName + '\'' + ", url='" + this.path + '\'' + ", parameters=" + this.queryParam + ", headers=" + this.headerParam + '}';
    }
}

