/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.config;

import com.arangodb.ArangoDBException;
import com.arangodb.Protocol;
import com.arangodb.config.ArangoConfigProperties;
import com.arangodb.config.HostDescription;
import com.arangodb.entity.LoadBalancingStrategy;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public final class ArangoConfigPropertiesImpl
implements ArangoConfigProperties {
    private static final String DEFAULT_PREFIX = "arangodb";
    private static final String DEFAULT_PROPERTY_FILE = "arangodb.properties";
    private final Properties properties;
    private final String prefix;

    public ArangoConfigPropertiesImpl() {
        this(DEFAULT_PROPERTY_FILE, DEFAULT_PREFIX);
    }

    public ArangoConfigPropertiesImpl(String fileName) {
        this(fileName, DEFAULT_PREFIX);
    }

    public ArangoConfigPropertiesImpl(String fileName, String prefix) {
        this.properties = this.initProperties(fileName);
        this.prefix = this.initPrefix(prefix);
    }

    private String initPrefix(String p) {
        if (p == null) {
            return "";
        }
        return p + ".";
    }

    private Properties initProperties(String fileName) {
        Properties p = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            p.load(is);
        }
        catch (Exception e) {
            throw new ArangoDBException("Got exception while reading properties file " + fileName, e);
        }
        return p;
    }

    private String getProperty(String key) {
        return this.properties.getProperty(this.prefix + key);
    }

    @Override
    public Optional<List<HostDescription>> getHosts() {
        return Optional.ofNullable(this.getProperty("hosts")).map(s -> {
            String[] hosts;
            ArrayList<HostDescription> hostDescriptions = new ArrayList<HostDescription>();
            for (String host : hosts = s.split(",")) {
                hostDescriptions.add(HostDescription.parse(host));
            }
            return hostDescriptions;
        });
    }

    @Override
    public Optional<Protocol> getProtocol() {
        return Optional.ofNullable(this.getProperty("protocol")).map(Protocol::valueOf);
    }

    @Override
    public Optional<String> getUser() {
        return Optional.ofNullable(this.getProperty("user"));
    }

    @Override
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.getProperty("password"));
    }

    @Override
    public Optional<String> getJwt() {
        return Optional.ofNullable(this.getProperty("jwt"));
    }

    @Override
    public Optional<Integer> getTimeout() {
        return Optional.ofNullable(this.getProperty("timeout")).map(Integer::valueOf);
    }

    @Override
    public Optional<Boolean> getUseSsl() {
        return Optional.ofNullable(this.getProperty("useSsl")).map(Boolean::valueOf);
    }

    @Override
    public Optional<Boolean> getVerifyHost() {
        return Optional.ofNullable(this.getProperty("verifyHost")).map(Boolean::valueOf);
    }

    @Override
    public Optional<Integer> getChunkSize() {
        return Optional.ofNullable(this.getProperty("chunkSize")).map(Integer::valueOf);
    }

    @Override
    public Optional<Integer> getMaxConnections() {
        return Optional.ofNullable(this.getProperty("maxConnections")).map(Integer::valueOf);
    }

    @Override
    public Optional<Long> getConnectionTtl() {
        return Optional.ofNullable(this.getProperty("connectionTtl")).map(Long::valueOf);
    }

    @Override
    public Optional<Integer> getKeepAliveInterval() {
        return Optional.ofNullable(this.getProperty("keepAliveInterval")).map(Integer::valueOf);
    }

    @Override
    public Optional<Boolean> getAcquireHostList() {
        return Optional.ofNullable(this.getProperty("acquireHostList")).map(Boolean::valueOf);
    }

    @Override
    public Optional<Integer> getAcquireHostListInterval() {
        return Optional.ofNullable(this.getProperty("acquireHostListInterval")).map(Integer::valueOf);
    }

    @Override
    public Optional<LoadBalancingStrategy> getLoadBalancingStrategy() {
        return Optional.ofNullable(this.getProperty("loadBalancingStrategy")).map(LoadBalancingStrategy::valueOf);
    }

    @Override
    public Optional<Integer> getResponseQueueTimeSamples() {
        return Optional.ofNullable(this.getProperty("responseQueueTimeSamples")).map(Integer::valueOf);
    }
}

