/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.util.HostUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHostResolver
implements HostResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedHostResolver.class);
    private final HostSet hosts;
    private final ArangoConfig config;
    private final ConnectionFactory connectionFactory;
    private final Integer acquireHostListInterval;
    private long lastUpdate;
    private ArangoExecutorSync executor;
    private InternalSerde arangoSerialization;

    public ExtendedHostResolver(List<Host> hosts, ArangoConfig config, ConnectionFactory connectionFactory, Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
        this.hosts = new HostSet(hosts);
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.lastUpdate = 0L;
    }

    @Override
    public void init(ArangoExecutorSync executor, InternalSerde arangoSerialization) {
        this.executor = executor;
        this.arangoSerialization = arangoSerialization;
    }

    @Override
    public HostSet resolve(boolean initial, boolean closeConnections) {
        if (!initial && this.isExpired()) {
            this.lastUpdate = System.currentTimeMillis();
            Collection<String> endpoints = this.resolveFromServer();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve {} Endpoints", (Object)endpoints.size());
                LOGGER.debug("Endpoints {}", (Object)Arrays.deepToString(endpoints.toArray()));
            }
            if (!endpoints.isEmpty()) {
                this.hosts.markAllForDeletion();
            }
            for (String endpoint : endpoints) {
                LOGGER.debug("Create HOST from {}", (Object)endpoint);
                if (endpoint.matches(".*://.+:[0-9]+")) {
                    HostDescription description;
                    String[] s = endpoint.replaceAll(".*://", "").split(":");
                    if (s.length == 2) {
                        description = new HostDescription(s[0], Integer.parseInt(s[1]));
                        this.hosts.addHost(HostUtils.createHost(description, this.config, this.connectionFactory));
                        continue;
                    }
                    if (s.length == 4) {
                        description = new HostDescription("127.0.0.1", Integer.parseInt(s[3]));
                        this.hosts.addHost(HostUtils.createHost(description, this.config, this.connectionFactory));
                        continue;
                    }
                    LOGGER.warn("Skip Endpoint (Missing Port) {}", (Object)endpoint);
                    continue;
                }
                LOGGER.warn("Skip Endpoint (Format) {}", (Object)endpoint);
            }
            this.hosts.clearAllMarkedForDeletion();
        }
        return this.hosts;
    }

    private Collection<String> resolveFromServer() {
        List<String> response;
        try {
            response = this.executor.execute(new InternalRequest("_system", RequestType.GET, "/_api/cluster/endpoints"), response1 -> {
                List tmp = (List)this.arangoSerialization.deserialize(response1.getBody(), "/endpoints", SerdeUtils.constructParametricType(List.class, SerdeUtils.constructParametricType(Map.class, new Type[]{String.class, String.class})));
                ArrayList<String> endpoints = new ArrayList<String>();
                for (Map map : tmp) {
                    endpoints.add((String)map.get("endpoint"));
                }
                return endpoints;
            }, null);
        }
        catch (ArangoDBException e) {
            Integer responseCode = e.getResponseCode();
            if (responseCode != null && (responseCode == 403 || responseCode == 501)) {
                response = Collections.emptyList();
            }
            throw e;
        }
        return response;
    }

    private boolean isExpired() {
        return System.currentTimeMillis() > this.lastUpdate + (long)this.acquireHostListInterval.intValue();
    }
}

