/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.internal.serde.InternalAnnotationIntrospector;
import com.arangodb.internal.serde.InternalModule;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.serde.UserDataDeserializer;
import com.arangodb.internal.serde.UserDataSerializer;
import com.arangodb.serde.ArangoSerde;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

final class InternalSerdeImpl
implements InternalSerde {
    private final ArangoSerde userSerde;
    private final ObjectMapper mapper;

    InternalSerdeImpl(ObjectMapper mapper, ArangoSerde userSerde, Module protocolModule) {
        this.mapper = mapper;
        this.userSerde = userSerde;
        mapper.deactivateDefaultTyping();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule(InternalModule.INSTANCE.get());
        if (protocolModule != null) {
            mapper.registerModule(protocolModule);
        }
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new InternalAnnotationIntrospector(new UserDataSerializer(this), new UserDataDeserializer(this)));
    }

    @Override
    public byte[] serialize(Object value) {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) {
        return this.deserialize(content, (Type)clazz);
    }

    @Override
    public String toJsonString(byte[] content) {
        try {
            return SerdeUtils.INSTANCE.writeJson(this.mapper.readTree(content));
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public byte[] extract(byte[] content, String jsonPointer) {
        try {
            JsonNode target = this.parse(content).at(jsonPointer);
            return this.mapper.writeValueAsBytes((Object)target);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public JsonNode parse(byte[] content) {
        try {
            return this.mapper.readTree(content);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public JsonNode parse(byte[] content, String jsonPointer) {
        try {
            return this.mapper.readTree(content).at(jsonPointer);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public byte[] serializeUserData(Object value) {
        if (value == null) {
            return this.serialize(null);
        }
        Class<?> clazz = value.getClass();
        if (this.isManagedClass(clazz)) {
            return this.serialize(value);
        }
        return this.userSerde.serialize(value);
    }

    @Override
    public byte[] serializeCollectionUserData(Collection<?> value) {
        List jsonNodeCollection = value.stream().map(this::serializeUserData).map(this::parse).collect(Collectors.toList());
        return this.serialize(jsonNodeCollection);
    }

    @Override
    public <T> T deserializeUserData(byte[] content, Class<T> clazz) {
        if (this.isManagedClass(clazz)) {
            return this.deserialize(content, clazz);
        }
        return this.userSerde.deserialize(content, clazz);
    }

    @Override
    public <T> T deserializeUserData(byte[] content, Type type) {
        if (type instanceof Class) {
            return this.deserializeUserData(content, (Class)type);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserializeUserData(JsonNode node, Type type) {
        return this.deserializeUserData(this.serialize(node), type);
    }

    @Override
    public ArangoSerde getUserSerde() {
        return this.userSerde;
    }

    @Override
    public <T> T deserialize(JsonNode node, Type type) {
        try {
            return (T)this.mapper.readerFor(this.mapper.constructType(type)).readValue(node);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) {
        if (content == null) {
            return null;
        }
        try {
            return (T)this.mapper.readerFor(this.mapper.constructType(type)).readValue(content);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    private boolean isManagedClass(Class<?> clazz) {
        return JsonNode.class.isAssignableFrom(clazz) || RawJson.class.equals(clazz) || RawBytes.class.equals(clazz) || BaseDocument.class.equals(clazz) || BaseEdgeDocument.class.equals(clazz);
    }

    static {
        SerdeUtils.checkSupportedJacksonVersion();
    }
}

