/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import java.util.HashMap;
import java.util.Map;

public final class Request<T> {
    private final String db;
    private final Method method;
    private final String path;
    private final Map<String, String> queryParams;
    private final Map<String, String> headers;
    private final T body;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private Request(String db, Method method, String path, Map<String, String> queryParams, Map<String, String> headers, T body) {
        this.db = db;
        this.method = method;
        this.path = path;
        this.queryParams = queryParams;
        this.headers = headers;
        this.body = body;
    }

    public String getDb() {
        return this.db;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public static enum Method {
        DELETE,
        GET,
        POST,
        PUT,
        HEAD,
        PATCH,
        OPTIONS;

    }

    public static final class Builder<T> {
        private String db;
        private Method method;
        private String path;
        private final Map<String, String> queryParams = new HashMap<String, String>();
        private final Map<String, String> headers = new HashMap<String, String>();
        private T body;

        public Builder<T> db(String db) {
            this.db = db;
            return this;
        }

        public Builder<T> method(Method method) {
            this.method = method;
            return this;
        }

        public Builder<T> path(String path) {
            this.path = path;
            return this;
        }

        public Builder<T> queryParam(String key, String value) {
            if (value != null) {
                this.queryParams.put(key, value);
            }
            return this;
        }

        public Builder<T> queryParams(Map<String, String> queryParams) {
            if (queryParams != null) {
                for (Map.Entry<String, String> it : queryParams.entrySet()) {
                    this.queryParam(it.getKey(), it.getValue());
                }
            }
            return this;
        }

        public Builder<T> header(String key, String value) {
            if (value != null) {
                this.headers.put(key, value);
            }
            return this;
        }

        public Builder<T> headers(Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> it : headers.entrySet()) {
                    this.header(it.getKey(), it.getValue());
                }
            }
            return this;
        }

        public Builder<T> body(T body) {
            this.body = body;
            return this;
        }

        public Request<T> build() {
            return new Request(this.db, this.method, this.path, this.queryParams, this.headers, this.body);
        }
    }
}

