/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollectionAsync;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ShardEntity;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.MDIndexOptions;
import com.arangodb.model.MDPrefixedIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.util.RawData;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoCollectionAsyncImpl
extends InternalArangoCollection
implements ArangoCollectionAsync {
    private final ArangoDatabaseAsync db;

    protected ArangoCollectionAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db;
    }

    @Override
    public CompletableFuture<DocumentCreateEntity<Void>> insertDocument(Object value) {
        return this.executorAsync().execute(() -> this.insertDocumentRequest(value, new DocumentCreateOptions()), SerdeUtils.constructParametricType(DocumentCreateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> CompletableFuture<DocumentCreateEntity<T>> insertDocument(T value, DocumentCreateOptions options) {
        return this.insertDocument(value, options, value.getClass());
    }

    @Override
    public <T> CompletableFuture<DocumentCreateEntity<T>> insertDocument(T value, DocumentCreateOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.insertDocumentRequest(value, options), SerdeUtils.constructParametricType(DocumentCreateEntity.class, type));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<Void>>> insertDocuments(RawData values) {
        return this.executorAsync().execute(() -> this.insertDocumentsRequest(values, new DocumentCreateOptions()), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<RawData>>> insertDocuments(RawData values, DocumentCreateOptions options) {
        return this.executorAsync().execute(() -> this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<Void>>> insertDocuments(Iterable<?> values) {
        return this.insertDocuments(values, new DocumentCreateOptions());
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<Void>>> insertDocuments(Iterable<?> values, DocumentCreateOptions options) {
        return this.executorAsync().execute(() -> this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocuments(Iterable<? extends T> values, DocumentCreateOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(Iterable<?> values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(Iterable<?> values, DocumentImportOptions options) {
        return this.executorAsync().execute(() -> this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(RawData values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(RawData values, DocumentImportOptions options) {
        return this.executorAsync().execute(() -> this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String key, Class<T> type) {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String key, Class<T> type, DocumentReadOptions options) {
        return this.executorAsync().execute(() -> this.getDocumentRequest(key, options), this.getDocumentResponseDeserializer(type)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && (ArangoErrors.matches(aEx = (ArangoDBException)e, 304) || ArangoErrors.matches(aEx, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(aEx, 412, ArangoErrors.ERROR_ARANGO_CONFLICT))) {
                return null;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<T>> getDocuments(Iterable<String> keys, Class<T> type) {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<T>> getDocuments(Iterable<String> keys, Class<T> type, DocumentReadOptions options) {
        return this.executorAsync().execute(() -> this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<DocumentUpdateEntity<Void>> replaceDocument(String key, Object value) {
        return this.executorAsync().execute(() -> this.replaceDocumentRequest(key, value, new DocumentReplaceOptions()), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> replaceDocument(String key, T value, DocumentReplaceOptions options) {
        return this.replaceDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> replaceDocument(String key, T value, DocumentReplaceOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.replaceDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, type));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> replaceDocuments(RawData values) {
        return this.executorAsync().execute(() -> this.replaceDocumentsRequest(values, new DocumentReplaceOptions()), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<RawData>>> replaceDocuments(RawData values, DocumentReplaceOptions options) {
        return this.executorAsync().execute(() -> this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> replaceDocuments(Iterable<?> values) {
        return this.replaceDocuments(values, new DocumentReplaceOptions());
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> replaceDocuments(Iterable<?> values, DocumentReplaceOptions options) {
        return this.executorAsync().execute(() -> this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocuments(Iterable<? extends T> values, DocumentReplaceOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<DocumentUpdateEntity<Void>> updateDocument(String key, Object value) {
        return this.updateDocument(key, value, new DocumentUpdateOptions(), Void.class);
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> updateDocument(String key, T value, DocumentUpdateOptions options) {
        return this.updateDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> updateDocument(String key, Object value, DocumentUpdateOptions options, Class<T> returnType) {
        return this.executorAsync().execute(() -> this.updateDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, returnType));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> updateDocuments(RawData values) {
        return this.executorAsync().execute(() -> this.updateDocumentsRequest(values, new DocumentUpdateOptions()), this.updateDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<RawData>>> updateDocuments(RawData values, DocumentUpdateOptions options) {
        return this.executorAsync().execute(() -> this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> updateDocuments(Iterable<?> values) {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<Void>>> updateDocuments(Iterable<?> values, DocumentUpdateOptions options) {
        return this.updateDocuments(values, options, Void.class);
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocuments(Iterable<?> values, DocumentUpdateOptions options, Class<T> returnType) {
        return this.executorAsync().execute(() -> this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(returnType));
    }

    @Override
    public CompletableFuture<DocumentDeleteEntity<Void>> deleteDocument(String key) {
        return this.deleteDocument(key, new DocumentDeleteOptions());
    }

    @Override
    public CompletableFuture<DocumentDeleteEntity<Void>> deleteDocument(String key, DocumentDeleteOptions options) {
        return this.deleteDocument(key, options, Void.class);
    }

    @Override
    public <T> CompletableFuture<DocumentDeleteEntity<T>> deleteDocument(String key, DocumentDeleteOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.deleteDocumentRequest(key, options), SerdeUtils.constructParametricType(DocumentDeleteEntity.class, type));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<Void>>> deleteDocuments(RawData values) {
        return this.executorAsync().execute(() -> this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<RawData>>> deleteDocuments(RawData values, DocumentDeleteOptions options) {
        return this.executorAsync().execute(() -> this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<Void>>> deleteDocuments(Iterable<?> values) {
        return this.deleteDocuments(values, new DocumentDeleteOptions());
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<Void>>> deleteDocuments(Iterable<?> values, DocumentDeleteOptions options) {
        return this.deleteDocuments(values, options, Void.class);
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocuments(Iterable<?> values, DocumentDeleteOptions options, Class<T> type) {
        return this.executorAsync().execute(() -> this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<Boolean> documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public CompletableFuture<Boolean> documentExists(String key, DocumentExistsOptions options) {
        return ((CompletableFuture)this.executorAsync().execute(() -> this.documentExistsRequest(key, options), (Type)((Object)Void.class)).thenApply(it -> true)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && (ArangoErrors.matches(aEx = (ArangoDBException)e, 304) || ArangoErrors.matches(aEx, 404) || ArangoErrors.matches(aEx, 412))) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<IndexEntity> getIndex(String id) {
        return this.executorAsync().execute(() -> this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<InvertedIndexEntity> getInvertedIndex(String id) {
        return this.executorAsync().execute(() -> this.getIndexRequest(id), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public CompletableFuture<String> deleteIndex(String id) {
        return this.executorAsync().execute(() -> this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    public CompletableFuture<IndexEntity> ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) {
        return this.executorAsync().execute(() -> this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<InvertedIndexEntity> ensureInvertedIndex(InvertedIndexOptions options) {
        return this.executorAsync().execute(() -> this.createInvertedIndexRequest(options), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) {
        return this.executorAsync().execute(() -> this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public CompletableFuture<IndexEntity> ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) {
        return this.executorAsync().execute(() -> this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) {
        return this.executorAsync().execute(() -> this.createTtlIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureZKDIndex(Iterable<String> fields, ZKDIndexOptions options) {
        return this.executorAsync().execute(() -> this.createZKDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureMDIndex(Iterable<String> fields, MDIndexOptions options) {
        return this.executorAsync().execute(() -> this.createMDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureMDPrefixedIndex(Iterable<String> fields, MDPrefixedIndexOptions options) {
        return this.executorAsync().execute(() -> this.createMDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<Collection<IndexEntity>> getIndexes() {
        return this.executorAsync().execute(this::getIndexesRequest, this.getIndexesResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<InvertedIndexEntity>> getInvertedIndexes() {
        return this.executorAsync().execute(this::getIndexesRequest, this.getInvertedIndexesResponseDeserializer());
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<CollectionEntity> truncate() {
        return this.truncate(null);
    }

    @Override
    public CompletableFuture<CollectionEntity> truncate(CollectionTruncateOptions options) {
        return this.executorAsync().execute(() -> this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> count() {
        return this.count(null);
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> count(CollectionCountOptions options) {
        return this.executorAsync().execute(() -> this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> create() {
        return this.db().createCollection(this.name());
    }

    @Override
    public CompletableFuture<CollectionEntity> create(CollectionCreateOptions options) {
        return this.db().createCollection(this.name(), options);
    }

    @Override
    public CompletableFuture<Void> drop() {
        return this.executorAsync().execute(() -> this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> drop(boolean isSystem) {
        return this.executorAsync().execute(() -> this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> getInfo() {
        return this.executorAsync().execute(this::getInfoRequest, (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> getProperties() {
        return this.executorAsync().execute(this::getPropertiesRequest, (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> changeProperties(CollectionPropertiesOptions options) {
        return this.executorAsync().execute(() -> this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> rename(String newName) {
        return this.executorAsync().execute(() -> this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<ShardEntity> getResponsibleShard(Object value) {
        return this.executorAsync().execute(() -> this.responsibleShardRequest(value), (Type)((Object)ShardEntity.class));
    }

    @Override
    public CompletableFuture<CollectionRevisionEntity> getRevision() {
        return this.executorAsync().execute(this::getRevisionRequest, (Type)((Object)CollectionRevisionEntity.class));
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user, Permissions permissions) {
        return this.executorAsync().execute(() -> this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> revokeAccess(String user) {
        return this.executorAsync().execute(() -> this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> resetAccess(String user) {
        return this.executorAsync().execute(() -> this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Permissions> getPermissions(String user) {
        return this.executorAsync().execute(() -> this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }
}

