/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoSerdeAccessor;
import com.arangodb.internal.ArangoExecutorAsync;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.util.EncodeUtils;

public abstract class ArangoExecuteable
implements ArangoSerdeAccessor {
    private static final String SLASH = "/";
    private final ArangoExecutorSync executorSync;
    private final ArangoExecutorAsync executorAsync;
    private final InternalSerde serde;

    protected ArangoExecuteable(CommunicationProtocol protocol, ArangoConfig config) {
        this(new ArangoExecutorSync(protocol, config), new ArangoExecutorAsync(protocol, config), config.getInternalSerde());
    }

    protected ArangoExecuteable(ArangoExecuteable other) {
        this(other.executorSync, other.executorAsync, other.serde);
    }

    private ArangoExecuteable(ArangoExecutorSync executorSync, ArangoExecutorAsync executorAsync, InternalSerde serde) {
        this.executorSync = executorSync;
        this.executorAsync = executorAsync;
        this.serde = serde;
    }

    protected static String createPath(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            if (i > 0) {
                sb.append(SLASH);
            }
            String param = params[i].contains(SLASH) ? ArangoExecuteable.createPath(params[i].split(SLASH)) : EncodeUtils.encodeURIComponent(params[i]);
            sb.append(param);
        }
        return sb.toString();
    }

    protected ArangoExecutorSync executorSync() {
        return this.executorSync;
    }

    protected ArangoExecutorAsync executorAsync() {
        return this.executorAsync;
    }

    @Override
    public InternalSerde getSerde() {
        return this.serde;
    }

    protected InternalRequest request(String dbName, RequestType requestType, String ... path) {
        return new InternalRequest(dbName, requestType, ArangoExecuteable.createPath(path));
    }
}

