/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.QueueTimeMetrics;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.QueueTimeMetricsImpl;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.serde.InternalSerde;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ArangoExecutor {
    protected final CommunicationProtocol protocol;
    private final QueueTimeMetricsImpl qtMetrics;
    private final InternalSerde serde;
    private final String timeoutS;

    protected ArangoExecutor(CommunicationProtocol protocol, ArangoConfig config) {
        this.protocol = protocol;
        this.qtMetrics = new QueueTimeMetricsImpl(config.getResponseQueueTimeSamples());
        this.serde = config.getInternalSerde();
        this.timeoutS = config.getTimeout() >= 1000 ? Integer.toString(config.getTimeout() / 1000) : null;
    }

    public void disconnect() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    public void setJwt(String jwt) {
        this.protocol.setJwt(jwt);
    }

    protected <T> T createResult(Type type, InternalResponse response) {
        return this.serde.deserialize(response.getBody(), type);
    }

    protected final void interceptResponse(InternalResponse response) {
        String queueTime = response.getMeta("X-Arango-Queue-Time-Seconds");
        if (queueTime != null) {
            this.qtMetrics.add(Double.parseDouble(queueTime));
        }
    }

    protected final InternalRequest interceptRequest(InternalRequest request) {
        request.putHeaderParam("x-arango-queue-time-seconds", this.timeoutS);
        return request;
    }

    public QueueTimeMetrics getQueueTimeMetrics() {
        return this.qtMetrics;
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(InternalResponse var1);
    }
}

