/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.RequestContext;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.RequestContextHolder;
import com.arangodb.internal.RequestContextImpl;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArangoExecutorAsync
extends ArangoExecutor {
    private final Executor downstreamExecutor;

    public ArangoExecutorAsync(CommunicationProtocol protocol, ArangoConfig config) {
        super(protocol, config);
        this.downstreamExecutor = config.getAsyncExecutor();
    }

    public <T> CompletableFuture<T> execute(Supplier<InternalRequest> requestSupplier, Type type) {
        return this.execute(requestSupplier, type, null);
    }

    public <T> CompletableFuture<T> execute(Supplier<InternalRequest> requestSupplier, Type type, HostHandle hostHandle) {
        return this.execute(requestSupplier, (InternalResponse response) -> this.createResult(type, response), hostHandle);
    }

    public <T> CompletableFuture<T> execute(Supplier<InternalRequest> requestSupplier, ArangoExecutor.ResponseDeserializer<T> responseDeserializer) {
        return this.execute(requestSupplier, responseDeserializer, null);
    }

    public <T> CompletableFuture<T> execute(Supplier<InternalRequest> requestSupplier, ArangoExecutor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) {
        CompletionStage cf = ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(requestSupplier).thenApply(Supplier::get)).thenCompose(request -> this.protocol.executeAsync(this.interceptRequest((InternalRequest)request), hostHandle).thenApply(resp -> new ResponseWithRequest((InternalResponse)resp, new RequestContextImpl((InternalRequest)request))))).handle((r, e) -> {
            if (e != null) {
                throw ArangoDBException.of(e);
            }
            this.interceptResponse(r.response);
            return RequestContextHolder.INSTANCE.runWithCtx(r.context, () -> responseDeserializer.deserialize(r.response));
        });
        if (this.downstreamExecutor != null) {
            return ((CompletableFuture)cf).thenApplyAsync(Function.identity(), this.downstreamExecutor);
        }
        return cf;
    }

    private static class ResponseWithRequest {
        final InternalResponse response;
        final RequestContext context;

        ResponseWithRequest(InternalResponse response, RequestContext context) {
            this.response = response;
            this.context = context;
        }
    }
}

