/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.internal.ShadedProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtils.class);

    private JacksonUtils() {
    }

    public static void tryConfigureJsonFactory(Object jf) {
        try {
            JacksonUtils.configureJsonFactory(jf);
        }
        catch (Throwable t) {
            LOG.warn("Got exception while configuring JsonFactory, skipping...", t);
        }
    }

    private static void configureJsonFactory(Object jf) throws Exception {
        JsonFactory proxy = ShadedProxy.of(JsonFactory.class, jf);
        Version version = proxy.version();
        LOG.debug("Detected Jackson version: {}", (Object)version);
        String basePkg = jf.getClass().getPackage().getName();
        if (JacksonUtils.isAtLeastVersion(version, 2, 15)) {
            Class<?> srcClass = Class.forName(basePkg + "." + StreamReadConstraints.class.getSimpleName());
            StreamReadConstraints.Builder builder = ShadedProxy.of(StreamReadConstraints.Static.class, srcClass).builder().maxNumberLength(Integer.MAX_VALUE).maxStringLength(Integer.MAX_VALUE).maxNestingDepth(Integer.MAX_VALUE);
            if (JacksonUtils.isAtLeastVersion(version, 2, 16)) {
                builder = builder.maxNameLength(Integer.MAX_VALUE).maxDocumentLength(Long.MAX_VALUE);
            } else {
                LOG.debug("Skipping configuring StreamReadConstraints maxNameLength");
                LOG.debug("Skipping configuring StreamReadConstraints maxDocumentLength");
            }
            proxy.setStreamReadConstraints(builder.build());
        } else {
            LOG.debug("Skipping configuring StreamReadConstraints");
        }
        if (JacksonUtils.isAtLeastVersion(version, 2, 16)) {
            LOG.debug("Configuring StreamWriteConstraints ...");
            Class<?> swcClass = Class.forName(basePkg + "." + StreamWriteConstraints.class.getSimpleName());
            StreamWriteConstraints swc = ShadedProxy.of(StreamWriteConstraints.Static.class, swcClass).builder().maxNestingDepth(Integer.MAX_VALUE).build();
            proxy.setStreamWriteConstraints(swc);
        } else {
            LOG.debug("Skipping configuring StreamWriteConstraints");
        }
    }

    private static boolean isAtLeastVersion(Version version, int major, int minor) {
        int currentMajor = version.getMajorVersion();
        int currentMinor = version.getMinorVersion();
        return currentMajor > major || currentMajor == major && currentMinor >= minor;
    }

    public static interface JsonFactory {
        public Version version();

        public JsonFactory setStreamReadConstraints(StreamReadConstraints var1);

        public JsonFactory setStreamWriteConstraints(StreamWriteConstraints var1);
    }

    public static interface Version {
        public int getMajorVersion();

        public int getMinorVersion();

        public String toString();
    }

    public static interface StreamReadConstraints {

        public static interface Builder {
            public Builder maxNumberLength(int var1);

            public Builder maxStringLength(int var1);

            public Builder maxNestingDepth(int var1);

            public Builder maxNameLength(int var1);

            public Builder maxDocumentLength(long var1);

            public StreamReadConstraints build();
        }

        public static interface Static {
            public Builder builder();
        }
    }

    public static interface StreamWriteConstraints {

        public static interface Builder {
            public Builder maxNestingDepth(int var1);

            public StreamWriteConstraints build();
        }

        public static interface Static {
            public Builder builder();
        }
    }
}

