/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoSearch;
import com.arangodb.ArangoView;
import com.arangodb.SearchAlias;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.AqlQueryExplainEntity;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoCollectionImpl;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.ArangoSearchImpl;
import com.arangodb.internal.ArangoViewImpl;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.SearchAliasImpl;
import com.arangodb.internal.cursor.ArangoCursorImpl;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.ExplainAqlQueryOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class ArangoDatabaseImpl
extends InternalArangoDatabase
implements ArangoDatabase {
    private final ArangoDB arangoDB;

    protected ArangoDatabaseImpl(ArangoDBImpl arangoDB, String name) {
        super(arangoDB, name);
        this.arangoDB = arangoDB;
    }

    @Override
    public ArangoDB arango() {
        return this.arangoDB;
    }

    @Override
    public ArangoDBVersion getVersion() {
        return (ArangoDBVersion)this.executorSync().execute(this.getVersionRequest(), (Type)((Object)ArangoDBVersion.class));
    }

    @Override
    public ArangoDBEngine getEngine() {
        return (ArangoDBEngine)this.executorSync().execute(this.getEngineRequest(), (Type)((Object)ArangoDBEngine.class));
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DATABASE_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Collection<String> getAccessibleDatabases() {
        return this.executorSync().execute(this.getAccessibleDatabasesRequest(), this.getDatabaseResponseDeserializer());
    }

    @Override
    public ArangoCollection collection(String name) {
        return new ArangoCollectionImpl(this, name);
    }

    @Override
    public CollectionEntity createCollection(String name) {
        return (CollectionEntity)this.executorSync().execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity createCollection(String name, CollectionCreateOptions options) {
        return (CollectionEntity)this.executorSync().execute(this.createCollectionRequest(name, options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public Collection<CollectionEntity> getCollections() {
        return this.executorSync().execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public Collection<CollectionEntity> getCollections(CollectionsReadOptions options) {
        return this.executorSync().execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public IndexEntity getIndex(String id) {
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public String deleteIndex(String id) {
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public Boolean create() {
        return this.arango().createDatabase(this.name());
    }

    @Override
    public Boolean drop() {
        return this.executorSync().execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    @Override
    public void grantAccess(String user, Permissions permissions) {
        this.executorSync().execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void grantAccess(String user) {
        this.executorSync().execute(this.grantAccessRequest(user, Permissions.RW), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) {
        this.executorSync().execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) {
        this.executorSync().execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) {
        this.executorSync().execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) {
        return this.executorSync().execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, Map<String, Object> bindVars, AqlQueryOptions options) {
        InternalRequest request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        CursorEntity<T> result = this.executorSync().execute(request, this.cursorEntityDeserializer(type), hostHandle);
        return this.createCursor(result, type, options, hostHandle);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, Map<String, Object> bindVars) {
        return this.query(query, type, bindVars, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, AqlQueryOptions options) {
        return this.query(query, type, null, options);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type) {
        return this.query(query, type, null, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type) {
        return this.cursor(cursorId, type, null, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type, AqlQueryOptions options) {
        return this.cursor(cursorId, type, null, options);
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type, String nextBatchId) {
        return this.cursor(cursorId, type, nextBatchId, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type, String nextBatchId, AqlQueryOptions options) {
        options.allowRetry(nextBatchId != null);
        HostHandle hostHandle = new HostHandle();
        CursorEntity<T> result = this.executorSync().execute(this.queryNextRequest(cursorId, options, nextBatchId), this.cursorEntityDeserializer(type), hostHandle);
        return this.createCursor(result, type, options, hostHandle);
    }

    private <T> ArangoCursor<T> createCursor(CursorEntity<T> result, final Class<T> type, AqlQueryOptions opts, final HostHandle hostHandle) {
        final AqlQueryOptions options = opts != null ? opts : new AqlQueryOptions();
        ArangoCursorExecute execute = new ArangoCursorExecute<T>(){

            @Override
            public CursorEntity<T> next(String id, String nextBatchId) {
                return ArangoDatabaseImpl.this.executorSync().execute(ArangoDatabaseImpl.this.queryNextRequest(id, options, nextBatchId), ArangoDatabaseImpl.this.cursorEntityDeserializer(type), hostHandle);
            }

            @Override
            public void close(String id) {
                block2: {
                    try {
                        ArangoDatabaseImpl.this.executorSync().execute(ArangoDatabaseImpl.this.queryCloseRequest(id, options), (Type)((Object)Void.class), hostHandle);
                    }
                    catch (ArangoDBException e) {
                        if (ArangoErrors.matches(e, 404, 1600)) break block2;
                        throw e;
                    }
                }
            }
        };
        return new ArangoCursorImpl<T>(execute, type, result, options.getAllowRetry());
    }

    @Override
    public AqlExecutionExplainEntity explainQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        return (AqlExecutionExplainEntity)this.executorSync().execute(this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlExecutionExplainEntity.class));
    }

    @Override
    public AqlQueryExplainEntity explainAqlQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        return (AqlQueryExplainEntity)this.executorSync().execute(this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlQueryExplainEntity.class));
    }

    @Override
    public AqlQueryExplainEntity explainAqlQuery(String query, Map<String, Object> bindVars, ExplainAqlQueryOptions options) {
        return (AqlQueryExplainEntity)this.executorSync().execute(this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlQueryExplainEntity.class));
    }

    @Override
    public AqlParseEntity parseQuery(String query) {
        return (AqlParseEntity)this.executorSync().execute(this.parseQueryRequest(query), (Type)((Object)AqlParseEntity.class));
    }

    @Override
    public void clearQueryCache() {
        this.executorSync().execute(this.clearQueryCacheRequest(), (Type)((Object)Void.class));
    }

    @Override
    public QueryCachePropertiesEntity getQueryCacheProperties() {
        return (QueryCachePropertiesEntity)this.executorSync().execute(this.getQueryCachePropertiesRequest(), (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryCachePropertiesEntity setQueryCacheProperties(QueryCachePropertiesEntity properties) {
        return (QueryCachePropertiesEntity)this.executorSync().execute(this.setQueryCachePropertiesRequest(properties), (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity getQueryTrackingProperties() {
        return (QueryTrackingPropertiesEntity)this.executorSync().execute(this.getQueryTrackingPropertiesRequest(), (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) {
        return (QueryTrackingPropertiesEntity)this.executorSync().execute(this.setQueryTrackingPropertiesRequest(properties), (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public Collection<QueryEntity> getCurrentlyRunningQueries() {
        return (Collection)this.executorSync().execute(this.getCurrentlyRunningQueriesRequest(), SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public Collection<QueryEntity> getSlowQueries() {
        return (Collection)this.executorSync().execute(this.getSlowQueriesRequest(), SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public void clearSlowQueries() {
        this.executorSync().execute(this.clearSlowQueriesRequest(), (Type)((Object)Void.class));
    }

    @Override
    public void killQuery(String id) {
        this.executorSync().execute(this.killQueryRequest(id), (Type)((Object)Void.class));
    }

    @Override
    public void createAqlFunction(String name, String code, AqlFunctionCreateOptions options) {
        this.executorSync().execute(this.createAqlFunctionRequest(name, code, options), (Type)((Object)Void.class));
    }

    @Override
    public Integer deleteAqlFunction(String name, AqlFunctionDeleteOptions options) {
        return this.executorSync().execute(this.deleteAqlFunctionRequest(name, options), this.deleteAqlFunctionResponseDeserializer());
    }

    @Override
    public Collection<AqlFunctionEntity> getAqlFunctions(AqlFunctionGetOptions options) {
        return this.executorSync().execute(this.getAqlFunctionsRequest(options), this.getAqlFunctionsResponseDeserializer());
    }

    @Override
    public ArangoGraph graph(String name) {
        return new ArangoGraphImpl(this, name);
    }

    @Override
    public GraphEntity createGraph(String name, Iterable<EdgeDefinition> edgeDefinitions) {
        return this.createGraph(name, edgeDefinitions, new GraphCreateOptions());
    }

    @Override
    public GraphEntity createGraph(String name, Iterable<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.executorSync().execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public Collection<GraphEntity> getGraphs() {
        return this.executorSync().execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> T transaction(String action, Class<T> type, TransactionOptions options) {
        return this.executorSync().execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public StreamTransactionEntity beginStreamTransaction(StreamTransactionOptions options) {
        return this.executorSync().execute(this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity abortStreamTransaction(String id) {
        return this.executorSync().execute(this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity getStreamTransaction(String id) {
        return this.executorSync().execute(this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public Collection<TransactionEntity> getStreamTransactions() {
        return this.executorSync().execute(this.getStreamTransactionsRequest(), this.transactionsResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity commitStreamTransaction(String id) {
        return this.executorSync().execute(this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public DatabaseEntity getInfo() {
        return this.executorSync().execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public void reloadRouting() {
        this.executorSync().execute(this.reloadRoutingRequest(), (Type)((Object)Void.class));
    }

    @Override
    public Collection<ViewEntity> getViews() {
        return this.executorSync().execute(this.getViewsRequest(), this.getViewsResponseDeserializer());
    }

    @Override
    public ArangoView view(String name) {
        return new ArangoViewImpl(this, name);
    }

    @Override
    public ArangoSearch arangoSearch(String name) {
        return new ArangoSearchImpl(this, name);
    }

    @Override
    public SearchAlias searchAlias(String name) {
        return new SearchAliasImpl(this, name);
    }

    @Override
    public ViewEntity createView(String name, ViewType type) {
        return (ViewEntity)this.executorSync().execute(this.createViewRequest(name, type), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createArangoSearch(String name, ArangoSearchCreateOptions options) {
        return (ViewEntity)this.executorSync().execute(this.createArangoSearchRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createSearchAlias(String name, SearchAliasCreateOptions options) {
        return (ViewEntity)this.executorSync().execute(this.createSearchAliasRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public SearchAnalyzer createSearchAnalyzer(SearchAnalyzer analyzer) {
        return (SearchAnalyzer)this.executorSync().execute(this.createAnalyzerRequest(analyzer), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public SearchAnalyzer getSearchAnalyzer(String name) {
        return (SearchAnalyzer)this.executorSync().execute(this.getAnalyzerRequest(name), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public Collection<SearchAnalyzer> getSearchAnalyzers() {
        return this.executorSync().execute(this.getAnalyzersRequest(), this.getSearchAnalyzersResponseDeserializer());
    }

    @Override
    public void deleteSearchAnalyzer(String name) {
        this.deleteSearchAnalyzer(name, null);
    }

    @Override
    public void deleteSearchAnalyzer(String name, AnalyzerDeleteOptions options) {
        this.executorSync().execute(this.deleteAnalyzerRequest(name, options), (Type)((Object)Void.class));
    }
}

