/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.AqlQueryParseOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.ExplainAqlQueryOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.ViewCreateOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.ArangoSearchOptionsBuilder;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasOptionsBuilder;
import java.util.Collection;
import java.util.Map;

public abstract class InternalArangoDatabase
extends ArangoExecuteable {
    protected static final String PATH_API_DATABASE = "/_api/database";
    private static final String PATH_API_VERSION = "/_api/version";
    private static final String PATH_API_ENGINE = "/_api/engine";
    private static final String PATH_API_CURSOR = "/_api/cursor";
    private static final String PATH_API_TRANSACTION = "/_api/transaction";
    private static final String PATH_API_BEGIN_STREAM_TRANSACTION = "/_api/transaction/begin";
    private static final String PATH_API_AQLFUNCTION = "/_api/aqlfunction";
    private static final String PATH_API_EXPLAIN = "/_api/explain";
    private static final String PATH_API_QUERY = "/_api/query";
    private static final String PATH_API_QUERY_CACHE = "/_api/query-cache";
    private static final String PATH_API_QUERY_CACHE_PROPERTIES = "/_api/query-cache/properties";
    private static final String PATH_API_QUERY_PROPERTIES = "/_api/query/properties";
    private static final String PATH_API_QUERY_CURRENT = "/_api/query/current";
    private static final String PATH_API_QUERY_SLOW = "/_api/query/slow";
    private static final String PATH_API_ADMIN_ROUTING_RELOAD = "/_admin/routing/reload";
    private static final String PATH_API_USER = "/_api/user";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final String name;

    protected InternalArangoDatabase(ArangoExecuteable executeable, String name) {
        super(executeable);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(String.class));
    }

    protected InternalRequest getAccessibleDatabasesRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_DATABASE, "user");
    }

    protected InternalRequest getVersionRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_VERSION);
    }

    protected InternalRequest getEngineRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_ENGINE);
    }

    protected InternalRequest createCollectionRequest(String name, CollectionCreateOptions options) {
        byte[] body = this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new CollectionCreateOptions(), name));
        return this.request(this.name, RequestType.POST, "/_api/collection").setBody(body);
    }

    protected InternalRequest getCollectionsRequest(CollectionsReadOptions options) {
        InternalRequest request = this.request(this.name, RequestType.GET, "/_api/collection");
        CollectionsReadOptions params = options != null ? options : new CollectionsReadOptions();
        request.putQueryParam("excludeSystem", params.getExcludeSystem());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<CollectionEntity>> getCollectionsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(CollectionEntity.class));
    }

    protected InternalRequest dropRequest() {
        return this.request("_system", RequestType.DELETE, PATH_API_DATABASE, this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDropResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", Boolean.class);
    }

    protected InternalRequest grantAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", this.name).setBody(this.getSerde().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected InternalRequest resetAccessRequest(String user) {
        return this.request("_system", RequestType.DELETE, PATH_API_USER, user, "database", this.name);
    }

    protected InternalRequest updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", this.name, "*").setBody(this.getSerde().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected InternalRequest getPermissionsRequest(String user) {
        return this.request("_system", RequestType.GET, PATH_API_USER, user, "database", this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", Permissions.class);
    }

    protected InternalRequest queryRequest(String query, Map<String, Object> bindVars, AqlQueryOptions options) {
        AqlQueryOptions opt = options != null ? options : new AqlQueryOptions();
        InternalRequest request = this.request(this.name, RequestType.POST, PATH_API_CURSOR).setBody(this.getSerde().serialize(OptionsBuilder.build(opt, query, bindVars)));
        if (Boolean.TRUE.equals(opt.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected InternalRequest queryNextRequest(String id, AqlQueryOptions options, String nextBatchId) {
        AqlQueryOptions opt;
        InternalRequest request = this.request(this.name, RequestType.POST, PATH_API_CURSOR, id, nextBatchId);
        AqlQueryOptions aqlQueryOptions = opt = options != null ? options : new AqlQueryOptions();
        if (Boolean.TRUE.equals(opt.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected InternalRequest queryCloseRequest(String id, AqlQueryOptions options) {
        AqlQueryOptions opt;
        InternalRequest request = this.request(this.name, RequestType.DELETE, PATH_API_CURSOR, id);
        AqlQueryOptions aqlQueryOptions = opt = options != null ? options : new AqlQueryOptions();
        if (Boolean.TRUE.equals(opt.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected InternalRequest explainQueryRequest(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        AqlQueryExplainOptions opt = options != null ? options : new AqlQueryExplainOptions();
        return this.request(this.name, RequestType.POST, PATH_API_EXPLAIN).setBody(this.getSerde().serialize(OptionsBuilder.build(opt, query, bindVars)));
    }

    protected InternalRequest explainQueryRequest(String query, Map<String, Object> bindVars, ExplainAqlQueryOptions options) {
        ExplainAqlQueryOptions opt = options != null ? options : new ExplainAqlQueryOptions();
        return this.request(this.name, RequestType.POST, PATH_API_EXPLAIN).setBody(this.getSerde().serialize(OptionsBuilder.build(opt, query, bindVars)));
    }

    protected InternalRequest parseQueryRequest(String query) {
        return this.request(this.name, RequestType.POST, PATH_API_QUERY).setBody(this.getSerde().serialize(OptionsBuilder.build(new AqlQueryParseOptions(), query)));
    }

    protected InternalRequest clearQueryCacheRequest() {
        return this.request(this.name, RequestType.DELETE, PATH_API_QUERY_CACHE);
    }

    protected InternalRequest getQueryCachePropertiesRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_QUERY_CACHE_PROPERTIES);
    }

    protected InternalRequest setQueryCachePropertiesRequest(QueryCachePropertiesEntity properties) {
        return this.request(this.name, RequestType.PUT, PATH_API_QUERY_CACHE_PROPERTIES).setBody(this.getSerde().serialize(properties));
    }

    protected InternalRequest getQueryTrackingPropertiesRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_QUERY_PROPERTIES);
    }

    protected InternalRequest setQueryTrackingPropertiesRequest(QueryTrackingPropertiesEntity properties) {
        return this.request(this.name, RequestType.PUT, PATH_API_QUERY_PROPERTIES).setBody(this.getSerde().serialize(properties));
    }

    protected InternalRequest getCurrentlyRunningQueriesRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_QUERY_CURRENT);
    }

    protected InternalRequest getSlowQueriesRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_QUERY_SLOW);
    }

    protected InternalRequest clearSlowQueriesRequest() {
        return this.request(this.name, RequestType.DELETE, PATH_API_QUERY_SLOW);
    }

    protected InternalRequest killQueryRequest(String id) {
        return this.request(this.name, RequestType.DELETE, PATH_API_QUERY, id);
    }

    protected InternalRequest createAqlFunctionRequest(String name, String code, AqlFunctionCreateOptions options) {
        return this.request(this.name, RequestType.POST, PATH_API_AQLFUNCTION).setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new AqlFunctionCreateOptions(), name, code)));
    }

    protected InternalRequest deleteAqlFunctionRequest(String name, AqlFunctionDeleteOptions options) {
        InternalRequest request = this.request(this.name, RequestType.DELETE, PATH_API_AQLFUNCTION, name);
        AqlFunctionDeleteOptions params = options != null ? options : new AqlFunctionDeleteOptions();
        request.putQueryParam("group", params.getGroup());
        return request;
    }

    public <T> ArangoExecutor.ResponseDeserializer<CursorEntity<T>> cursorEntityDeserializer(Class<T> type) {
        return response -> {
            CursorEntity e = (CursorEntity)this.getSerde().deserialize(response.getBody(), SerdeUtils.constructParametricType(CursorEntity.class, type));
            boolean potentialDirtyRead = Boolean.parseBoolean(response.getMeta("X-Arango-Potential-Dirty-Read"));
            e.setPotentialDirtyRead(potentialDirtyRead);
            return e;
        };
    }

    protected ArangoExecutor.ResponseDeserializer<Integer> deleteAqlFunctionResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/deletedCount", Integer.class);
    }

    protected InternalRequest getAqlFunctionsRequest(AqlFunctionGetOptions options) {
        InternalRequest request = this.request(this.name, RequestType.GET, PATH_API_AQLFUNCTION);
        AqlFunctionGetOptions params = options != null ? options : new AqlFunctionGetOptions();
        request.putQueryParam("namespace", params.getNamespace());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<AqlFunctionEntity>> getAqlFunctionsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(AqlFunctionEntity.class));
    }

    protected InternalRequest createGraphRequest(String name, Iterable<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        GraphCreateOptions opts = options != null ? options : new GraphCreateOptions();
        return this.request(this.name, RequestType.POST, "/_api/gharial").putQueryParam("waitForSync", opts.getWaitForSync()).setBody(this.getSerde().serialize(OptionsBuilder.build(opts, name, edgeDefinitions)));
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> createGraphResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/graph", GraphEntity.class);
    }

    protected InternalRequest getGraphsRequest() {
        return this.request(this.name, RequestType.GET, "/_api/gharial");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<GraphEntity>> getGraphsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/graphs", SerdeUtils.constructListType(GraphEntity.class));
    }

    protected InternalRequest transactionRequest(String action, TransactionOptions options) {
        return this.request(this.name, RequestType.POST, PATH_API_TRANSACTION).setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new TransactionOptions(), action)));
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> transactionResponseDeserializer(Class<T> type) {
        return response -> {
            byte[] userContent = this.getSerde().extract(response.getBody(), "/result");
            return this.getSerde().deserializeUserData(userContent, type);
        };
    }

    protected InternalRequest beginStreamTransactionRequest(StreamTransactionOptions options) {
        StreamTransactionOptions opts = options != null ? options : new StreamTransactionOptions();
        InternalRequest r = this.request(this.name, RequestType.POST, PATH_API_BEGIN_STREAM_TRANSACTION).setBody(this.getSerde().serialize(opts));
        if (Boolean.TRUE.equals(opts.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(r);
        }
        return r;
    }

    protected InternalRequest abortStreamTransactionRequest(String id) {
        return this.request(this.name, RequestType.DELETE, PATH_API_TRANSACTION, id);
    }

    protected InternalRequest getStreamTransactionsRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_TRANSACTION);
    }

    protected InternalRequest getStreamTransactionRequest(String id) {
        return this.request(this.name, RequestType.GET, PATH_API_TRANSACTION, id);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<TransactionEntity>> transactionsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/transactions", SerdeUtils.constructListType(TransactionEntity.class));
    }

    protected InternalRequest commitStreamTransactionRequest(String id) {
        return this.request(this.name, RequestType.PUT, PATH_API_TRANSACTION, id);
    }

    protected ArangoExecutor.ResponseDeserializer<StreamTransactionEntity> streamTransactionResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", StreamTransactionEntity.class);
    }

    protected InternalRequest getInfoRequest() {
        return this.request(this.name, RequestType.GET, PATH_API_DATABASE, "current");
    }

    protected ArangoExecutor.ResponseDeserializer<DatabaseEntity> getInfoResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", DatabaseEntity.class);
    }

    protected InternalRequest reloadRoutingRequest() {
        return this.request(this.name, RequestType.POST, PATH_API_ADMIN_ROUTING_RELOAD);
    }

    protected InternalRequest getViewsRequest() {
        return this.request(this.name, RequestType.GET, "/_api/view");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<ViewEntity>> getViewsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(ViewEntity.class));
    }

    protected InternalRequest createViewRequest(String name, ViewType type) {
        return this.request(this.name, RequestType.POST, "/_api/view").setBody(this.getSerde().serialize(OptionsBuilder.build(new ViewCreateOptions(), name, type)));
    }

    protected InternalRequest createArangoSearchRequest(String name, ArangoSearchCreateOptions options) {
        return this.request(this.name, RequestType.POST, "/_api/view").setBody(this.getSerde().serialize(ArangoSearchOptionsBuilder.build(options != null ? options : new ArangoSearchCreateOptions(), name)));
    }

    protected InternalRequest createSearchAliasRequest(String name, SearchAliasCreateOptions options) {
        return this.request(this.name, RequestType.POST, "/_api/view").setBody(this.getSerde().serialize(SearchAliasOptionsBuilder.build(options != null ? options : new SearchAliasCreateOptions(), name)));
    }

    protected InternalRequest getAnalyzerRequest(String name) {
        return this.request(this.name, RequestType.GET, "/_api/analyzer", name);
    }

    protected InternalRequest getAnalyzersRequest() {
        return this.request(this.name, RequestType.GET, "/_api/analyzer");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<SearchAnalyzer>> getSearchAnalyzersResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(SearchAnalyzer.class));
    }

    protected InternalRequest createAnalyzerRequest(SearchAnalyzer options) {
        return this.request(this.name, RequestType.POST, "/_api/analyzer").setBody(this.getSerde().serialize(options));
    }

    protected InternalRequest deleteAnalyzerRequest(String name, AnalyzerDeleteOptions options) {
        InternalRequest request = this.request(this.name, RequestType.DELETE, "/_api/analyzer", name);
        request.putQueryParam("force", options != null ? options.getForce() : null);
        return request;
    }
}

