/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.entity.ErrorEntity;
import java.util.Objects;
import java.util.concurrent.CompletionException;

public class ArangoDBException
extends RuntimeException {
    private static final long serialVersionUID = 6165638002614173801L;
    private final ErrorEntity entity;
    private final Integer responseCode;
    private final Long requestId;

    public ArangoDBException(ErrorEntity errorEntity) {
        super(String.format("Response: %s, Error: %s - %s", errorEntity.getCode(), errorEntity.getErrorNum(), errorEntity.getErrorMessage()));
        this.entity = errorEntity;
        this.responseCode = errorEntity.getCode();
        this.requestId = null;
    }

    public ArangoDBException(String message) {
        super(message);
        this.entity = null;
        this.responseCode = null;
        this.requestId = null;
    }

    public ArangoDBException(String message, Integer responseCode) {
        super(message);
        this.entity = null;
        this.responseCode = responseCode;
        this.requestId = null;
    }

    @Deprecated
    public ArangoDBException(Throwable cause) {
        super(cause);
        this.entity = null;
        this.responseCode = null;
        this.requestId = null;
    }

    @Deprecated
    public ArangoDBException(String message, Throwable cause) {
        super(message, cause);
        this.entity = null;
        this.responseCode = null;
        this.requestId = null;
    }

    @Deprecated
    public ArangoDBException(Throwable cause, long requestId) {
        super(cause);
        this.entity = null;
        this.responseCode = null;
        this.requestId = requestId;
    }

    private ArangoDBException(String message, Throwable cause, ErrorEntity entity, Integer responseCode, Long requestId) {
        super(message, cause);
        this.entity = entity;
        this.responseCode = responseCode;
        this.requestId = requestId;
    }

    public static ArangoDBException of(Throwable t) {
        return ArangoDBException.of(null, t);
    }

    public static ArangoDBException of(String message, Throwable t) {
        return ArangoDBException.of(message, t, null);
    }

    public static ArangoDBException of(Throwable t, Long requestId) {
        return ArangoDBException.of(null, t, requestId);
    }

    private static ArangoDBException of(String message, Throwable t, Long requestId) {
        Objects.requireNonNull(t);
        if (t instanceof CompletionException) {
            return ArangoDBException.of(message, t.getCause(), requestId);
        }
        Throwable cause = ArangoDBException.unwrapCause(t);
        String msg = message != null ? message : (t.getMessage() != null ? t.getMessage() : cause.getMessage());
        ErrorEntity entity = null;
        Integer responseCode = null;
        Long reqId = requestId;
        if (t instanceof ArangoDBException) {
            entity = ((ArangoDBException)t).entity;
            responseCode = ((ArangoDBException)t).responseCode;
            reqId = reqId != null ? reqId : ((ArangoDBException)t).requestId;
        }
        return new ArangoDBException(msg, cause, entity, responseCode, reqId);
    }

    private static Throwable unwrapCause(Throwable t) {
        if (t instanceof ArangoDBException && t.getCause() != null) {
            return ArangoDBException.unwrapCause(t.getCause());
        }
        return t;
    }

    public String getErrorMessage() {
        return this.entity != null ? this.entity.getErrorMessage() : null;
    }

    public String getException() {
        return this.entity != null ? this.entity.getException() : null;
    }

    public Integer getResponseCode() {
        Integer entityResponseCode = this.entity != null ? Integer.valueOf(this.entity.getCode()) : null;
        return this.responseCode != null ? this.responseCode : entityResponseCode;
    }

    public Integer getErrorNum() {
        return this.entity != null ? Integer.valueOf(this.entity.getErrorNum()) : null;
    }

    public Long getRequestId() {
        return this.requestId;
    }
}

