/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.ReplaceEdgeDefinitionOptions;
import com.arangodb.model.VertexCollectionCreateOptions;
import java.util.Collection;

public abstract class InternalArangoGraph
extends ArangoExecuteable {
    protected static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String GRAPH = "/graph";
    private static final String VERTEX = "vertex";
    private static final String EDGE = "edge";
    protected final String dbName;
    protected final String name;

    protected InternalArangoGraph(ArangoExecuteable executeable, String dbName, String name) {
        super(executeable);
        this.dbName = dbName;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    protected InternalRequest dropRequest() {
        return this.dropRequest(false);
    }

    protected InternalRequest dropRequest(boolean dropCollections) {
        InternalRequest request = this.request(this.dbName, RequestType.DELETE, PATH_API_GHARIAL, this.name);
        if (dropCollections) {
            request.putQueryParam("dropCollections", true);
        }
        return request;
    }

    protected InternalRequest getInfoRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_GHARIAL, this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> getInfoResponseDeserializer() {
        return this.addVertexCollectionResponseDeserializer();
    }

    protected InternalRequest getVertexCollectionsRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_GHARIAL, this.name, VERTEX);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getVertexCollectionsResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/collections", SerdeUtils.constructListType(String.class));
    }

    protected InternalRequest addVertexCollectionRequest(String name, VertexCollectionCreateOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_GHARIAL, this.name(), VERTEX);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options, name)));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addVertexCollectionResponseDeserializer() {
        return this.addEdgeDefinitionResponseDeserializer();
    }

    protected InternalRequest getEdgeDefinitionsRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_GHARIAL, this.name, EDGE);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getEdgeDefinitionsDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/collections", SerdeUtils.constructListType(String.class));
    }

    protected InternalRequest addEdgeDefinitionRequest(EdgeDefinition definition) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_GHARIAL, this.name, EDGE);
        request.setBody(this.getSerde().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addEdgeDefinitionResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), GRAPH, GraphEntity.class);
    }

    protected InternalRequest replaceEdgeDefinitionRequest(EdgeDefinition definition, ReplaceEdgeDefinitionOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_GHARIAL, this.name, EDGE, definition.getCollection()).putQueryParam("waitForSync", options.getWaitForSync()).putQueryParam("dropCollections", options.getDropCollections());
        request.setBody(this.getSerde().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> replaceEdgeDefinitionResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), GRAPH, GraphEntity.class);
    }
}

