/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

abstract class AbstractBaseDocument
implements Serializable {
    private static final long serialVersionUID = 6985324876843525239L;
    private static final String[] META_PROPS = new String[]{"_id", "_key", "_rev"};
    private final HashMap<String, Object> properties = new HashMap();

    AbstractBaseDocument() {
    }

    AbstractBaseDocument(String key) {
        this();
        this.setKey(key);
    }

    AbstractBaseDocument(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
    }

    @JsonIgnore
    public String getId() {
        return (String)this.getAttribute("_id");
    }

    public void setId(String id) {
        this.addAttribute("_id", id);
    }

    @JsonIgnore
    public String getKey() {
        return (String)this.getAttribute("_key");
    }

    public void setKey(String key) {
        this.addAttribute("_key", key);
    }

    @JsonIgnore
    public String getRevision() {
        return (String)this.getAttribute("_rev");
    }

    public void setRevision(String rev) {
        this.addAttribute("_rev", rev);
    }

    @JsonInclude
    @JsonAnyGetter
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @JsonIgnore
    public void setProperties(Map<String, Object> props) {
        for (String f : this.getMetaProps()) {
            this.requireString(f, props.get(f));
        }
        this.properties.putAll(props);
    }

    public Object getAttribute(String key) {
        return this.properties.get(key);
    }

    @JsonInclude
    @JsonAnySetter
    public void addAttribute(String key, Object value) {
        for (String f : this.getMetaProps()) {
            if (!f.equals(key)) continue;
            this.requireString(key, value);
        }
        this.properties.put(key, value);
    }

    public void updateAttribute(String key, Object value) {
        if (this.properties.containsKey(key)) {
            this.addAttribute(key, value);
        }
    }

    public void removeAttribute(String key) {
        this.properties.remove(key);
    }

    protected String[] getMetaProps() {
        return META_PROPS;
    }

    private void requireString(String k, Object v) {
        if (v != null && !(v instanceof String)) {
            throw new IllegalArgumentException(k + " must be a String");
        }
    }

    String stringify() {
        return "{properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBaseDocument that = (AbstractBaseDocument)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }
}

