/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch;

import com.arangodb.entity.arangosearch.ConsolidationType;
import java.util.Objects;

public final class ConsolidationPolicy {
    private ConsolidationType type;
    private Double threshold;
    private Long segmentsMin;
    private Long segmentsMax;
    private Long segmentsBytesMax;
    private Long segmentsBytesFloor;
    private Long minScore;
    private Double maxSkewThreshold;
    private Double minDeletionRatio;

    public static ConsolidationPolicy of(ConsolidationType type) {
        return new ConsolidationPolicy().type(type);
    }

    public ConsolidationPolicy type(ConsolidationType type) {
        this.type = type;
        return this;
    }

    public ConsolidationPolicy threshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public ConsolidationType getType() {
        return this.type;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Long getSegmentsMin() {
        return this.segmentsMin;
    }

    @Deprecated
    public ConsolidationPolicy segmentsMin(Long segmentsMin) {
        this.segmentsMin = segmentsMin;
        return this;
    }

    public Long getSegmentsMax() {
        return this.segmentsMax;
    }

    @Deprecated
    public ConsolidationPolicy segmentsMax(Long segmentsMax) {
        this.segmentsMax = segmentsMax;
        return this;
    }

    public Long getSegmentsBytesMax() {
        return this.segmentsBytesMax;
    }

    public ConsolidationPolicy segmentsBytesMax(Long segmentsBytesMax) {
        this.segmentsBytesMax = segmentsBytesMax;
        return this;
    }

    public Long getSegmentsBytesFloor() {
        return this.segmentsBytesFloor;
    }

    @Deprecated
    public ConsolidationPolicy segmentsBytesFloor(Long segmentsBytesFloor) {
        this.segmentsBytesFloor = segmentsBytesFloor;
        return this;
    }

    public Long getMinScore() {
        return this.minScore;
    }

    @Deprecated
    public ConsolidationPolicy minScore(Long minScore) {
        this.minScore = minScore;
        return this;
    }

    public Double getMaxSkewThreshold() {
        return this.maxSkewThreshold;
    }

    public ConsolidationPolicy maxSkewThreshold(Double maxSkewThreshold) {
        this.maxSkewThreshold = maxSkewThreshold;
        return this;
    }

    public Double getMinDeletionRatio() {
        return this.minDeletionRatio;
    }

    public ConsolidationPolicy minDeletionRatio(Double minDeletionRatio) {
        this.minDeletionRatio = minDeletionRatio;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsolidationPolicy that = (ConsolidationPolicy)o;
        return this.type == that.type && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.segmentsMin, that.segmentsMin) && Objects.equals(this.segmentsMax, that.segmentsMax) && Objects.equals(this.segmentsBytesMax, that.segmentsBytesMax) && Objects.equals(this.segmentsBytesFloor, that.segmentsBytesFloor) && Objects.equals(this.minScore, that.minScore) && Objects.equals(this.maxSkewThreshold, that.maxSkewThreshold) && Objects.equals(this.minDeletionRatio, that.minDeletionRatio);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.threshold, this.segmentsMin, this.segmentsMax, this.segmentsBytesMax, this.segmentsBytesFloor, this.minScore, this.maxSkewThreshold, this.minDeletionRatio});
    }

    public String toString() {
        return "ConsolidationPolicy{type=" + (Object)((Object)this.type) + ", threshold=" + this.threshold + ", segmentsMin=" + this.segmentsMin + ", segmentsMax=" + this.segmentsMax + ", segmentsBytesMax=" + this.segmentsBytesMax + ", segmentsBytesFloor=" + this.segmentsBytesFloor + ", minScore=" + this.minScore + ", maxSkewThreshold=" + this.maxSkewThreshold + ", minDeletionRatio=" + this.minDeletionRatio + '}';
    }
}

