/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.ViewRenameOptions;

public abstract class InternalArangoView
extends ArangoExecuteable {
    protected static final String PATH_API_VIEW = "/_api/view";
    protected static final String PATH_API_ANALYZER = "/_api/analyzer";
    protected final String dbName;
    protected final String name;

    protected InternalArangoView(ArangoExecuteable executeable, String dbName, String name) {
        super(executeable);
        this.dbName = dbName;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    protected InternalRequest dropRequest() {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_VIEW, this.name);
    }

    protected InternalRequest renameRequest(String newName) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_VIEW, this.name, "rename");
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(new ViewRenameOptions(), newName)));
        return request;
    }

    protected InternalRequest getInfoRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_VIEW, this.name);
    }
}

