/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBAsync;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.ArangoMetrics;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.entity.AccessToken;
import com.arangodb.entity.AccessTokens;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoMetricsImpl;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.AccessTokenCreateOptions;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class ArangoDBAsyncImpl
extends InternalArangoDB
implements ArangoDBAsync {
    private final ArangoDB arangoDB;

    public ArangoDBAsyncImpl(ArangoDBImpl arangoDB) {
        super(arangoDB);
        this.arangoDB = arangoDB;
    }

    @Override
    public void shutdown() {
        this.arangoDB.shutdown();
    }

    @Override
    public void updateJwt(String jwt) {
        this.arangoDB.updateJwt(jwt);
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db("_system");
    }

    @Override
    public ArangoDatabaseAsync db(String dbName) {
        return new ArangoDatabaseAsyncImpl(this, dbName);
    }

    @Override
    public ArangoMetrics metrics() {
        return new ArangoMetricsImpl(this.executorAsync().getQueueTimeMetrics());
    }

    @Override
    public CompletableFuture<Boolean> createDatabase(String dbName) {
        return this.createDatabase(new DBCreateOptions().name(dbName));
    }

    @Override
    public CompletableFuture<Boolean> createDatabase(DBCreateOptions options) {
        return this.executorAsync().execute(() -> this.createDatabaseRequest(options), this.createDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getDatabases() {
        return this.executorAsync().execute(() -> this.getDatabasesRequest("_system"), this.getDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabases() {
        return this.db().getAccessibleDatabases();
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabasesFor(String user) {
        return this.executorAsync().execute(() -> this.getAccessibleDatabasesForRequest("_system", user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public CompletableFuture<ArangoDBVersion> getVersion() {
        return this.db().getVersion();
    }

    @Override
    public CompletableFuture<ArangoDBEngine> getEngine() {
        return this.db().getEngine();
    }

    @Override
    public CompletableFuture<ServerRole> getRole() {
        return this.executorAsync().execute(this::getRoleRequest, this.getRoleResponseDeserializer());
    }

    @Override
    public CompletableFuture<String> getServerId() {
        return this.executorAsync().execute(this::getServerIdRequest, this.getServerIdResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd) {
        return this.executorAsync().execute(() -> this.createUserRequest("_system", user, passwd, new UserCreateOptions()), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd, UserCreateOptions options) {
        return this.executorAsync().execute(() -> this.createUserRequest("_system", user, passwd, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> deleteUser(String user) {
        return this.executorAsync().execute(() -> this.deleteUserRequest("_system", user), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<UserEntity> getUser(String user) {
        return this.executorAsync().execute(() -> this.getUserRequest("_system", user), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Collection<UserEntity>> getUsers() {
        return this.executorAsync().execute(() -> this.getUsersRequest("_system"), this.getUsersResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> updateUser(String user, UserUpdateOptions options) {
        return this.executorAsync().execute(() -> this.updateUserRequest("_system", user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> replaceUser(String user, UserUpdateOptions options) {
        return this.executorAsync().execute(() -> this.replaceUserRequest("_system", user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultDatabaseAccess(String user, Permissions permissions) {
        return this.executorAsync().execute(() -> this.updateUserDefaultDatabaseAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultCollectionAccess(String user, Permissions permissions) {
        return this.executorAsync().execute(() -> this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public <T> CompletableFuture<Response<T>> execute(Request<?> request, Class<T> type) {
        return this.executorAsync().execute(() -> this.executeRequest(request), this.responseDeserializer(type));
    }

    @Override
    public CompletableFuture<LogEntriesEntity> getLogEntries(LogOptions options) {
        return this.executorAsync().execute(() -> this.getLogEntriesRequest(options), (Type)((Object)LogEntriesEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> getLogLevel() {
        return this.getLogLevel(new LogLevelOptions());
    }

    @Override
    public CompletableFuture<LogLevelEntity> getLogLevel(LogLevelOptions options) {
        return this.executorAsync().execute(() -> this.getLogLevelRequest(options), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> setLogLevel(LogLevelEntity entity) {
        return this.setLogLevel(entity, new LogLevelOptions());
    }

    @Override
    public CompletableFuture<LogLevelEntity> setLogLevel(LogLevelEntity entity, LogLevelOptions options) {
        return this.executorAsync().execute(() -> this.setLogLevelRequest(entity, options), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> resetLogLevels(LogLevelOptions options) {
        return this.executorAsync().execute(() -> this.resetLogLevelsRequest(options), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<Collection<QueryOptimizerRule>> getQueryOptimizerRules() {
        return this.executorAsync().execute(this::getQueryOptimizerRulesRequest, SerdeUtils.constructListType(QueryOptimizerRule.class));
    }

    @Override
    public CompletableFuture<AccessToken> createAccessToken(String user, AccessTokenCreateOptions options) {
        return this.executorAsync().execute(() -> this.createAccessTokenRequest(user, options), (Type)((Object)AccessToken.class));
    }

    @Override
    public CompletableFuture<AccessTokens> getAccessTokens(String user) {
        return this.executorAsync().execute(() -> this.getAccessTokensRequest(user), (Type)((Object)AccessTokens.class));
    }

    @Override
    public CompletableFuture<Void> deleteAccessToken(String user, Long tokenId) {
        return this.executorAsync().execute(() -> this.deleteAccessTokenRequest(user, tokenId), (Type)((Object)Void.class));
    }
}

