/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.config;

import com.arangodb.Compression;
import com.arangodb.Protocol;
import com.arangodb.arch.UsedInApi;
import com.arangodb.config.ArangoConfigProperties;
import com.arangodb.config.HostDescription;
import com.arangodb.config.ProtocolConfig;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.internal.ArangoDefaults;
import com.arangodb.internal.serde.ContentTypeFactory;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.serde.InternalSerdeProvider;
import com.arangodb.serde.ArangoSerde;
import com.arangodb.serde.ArangoSerdeProvider;
import com.fasterxml.jackson.databind.Module;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

@UsedInApi
public class ArangoConfig {
    private final List<HostDescription> hosts = new ArrayList<HostDescription>();
    private Protocol protocol;
    private Integer timeout;
    private String user;
    private String password;
    private String jwt;
    private Boolean useSsl;
    private Optional<String> sslCertValue;
    private Optional<String> sslAlgorithm;
    private String sslProtocol;
    private Optional<String> sslTrustStorePath;
    private Optional<String> sslTrustStorePassword;
    private String sslTrustStoreType;
    private SSLContext sslContext;
    private Boolean verifyHost;
    private Integer chunkSize;
    private Boolean pipelining;
    private Integer connectionWindowSize;
    private Integer initialWindowSize;
    private Integer maxConnections;
    private Long connectionTtl;
    private Integer keepAliveInterval;
    private Boolean acquireHostList;
    private Integer acquireHostListInterval;
    private LoadBalancingStrategy loadBalancingStrategy;
    private InternalSerde internalSerde;
    private ArangoSerde userDataSerde;
    private Class<? extends ArangoSerdeProvider> serdeProviderClass;
    private Integer responseQueueTimeSamples;
    private Module protocolModule;
    private Executor asyncExecutor;
    private Compression compression;
    private Integer compressionThreshold;
    private Integer compressionLevel;
    private ProtocolConfig protocolConfig;

    public ArangoConfig() {
        this.loadProperties(new ArangoConfigProperties(){});
    }

    public void loadProperties(ArangoConfigProperties properties) {
        this.hosts.addAll(properties.getHosts().orElse(ArangoDefaults.DEFAULT_HOSTS).stream().map(it -> new HostDescription(it.getHost(), it.getPort())).collect(Collectors.toList()));
        this.protocol = properties.getProtocol().orElse(ArangoDefaults.DEFAULT_PROTOCOL);
        this.timeout = properties.getTimeout().orElse(ArangoDefaults.DEFAULT_TIMEOUT);
        this.user = properties.getUser().orElse("root");
        this.password = properties.getPassword().orElse(null);
        this.jwt = properties.getJwt().orElse(null);
        this.useSsl = properties.getUseSsl().orElse(ArangoDefaults.DEFAULT_USE_SSL);
        this.sslCertValue = properties.getSslCertValue();
        this.sslAlgorithm = properties.getSslAlgorithm();
        this.sslProtocol = properties.getSslProtocol().orElse("TLS");
        this.sslTrustStorePath = properties.getSslTrustStorePath();
        this.sslTrustStorePassword = properties.getSslTrustStorePassword();
        this.sslTrustStoreType = properties.getSslTrustStoreType().orElse("PKCS12");
        this.verifyHost = properties.getVerifyHost().orElse(ArangoDefaults.DEFAULT_VERIFY_HOST);
        this.chunkSize = properties.getChunkSize().orElse(ArangoDefaults.DEFAULT_CHUNK_SIZE);
        this.pipelining = properties.getPipelining().orElse(ArangoDefaults.DEFAULT_PIPELINING);
        this.connectionWindowSize = properties.getConnectionWindowSize().orElse(ArangoDefaults.DEFAULT_CONNECTION_WINDOW_SIZE);
        this.initialWindowSize = properties.getInitialWindowSize().orElse(ArangoDefaults.DEFAULT_INITIAL_WINDOW_SIZE);
        this.maxConnections = properties.getMaxConnections().orElse(null);
        this.connectionTtl = properties.getConnectionTtl().orElse(null);
        this.keepAliveInterval = properties.getKeepAliveInterval().orElse(null);
        this.acquireHostList = properties.getAcquireHostList().orElse(ArangoDefaults.DEFAULT_ACQUIRE_HOST_LIST);
        this.acquireHostListInterval = properties.getAcquireHostListInterval().orElse(ArangoDefaults.DEFAULT_ACQUIRE_HOST_LIST_INTERVAL);
        this.loadBalancingStrategy = properties.getLoadBalancingStrategy().orElse(ArangoDefaults.DEFAULT_LOAD_BALANCING_STRATEGY);
        this.responseQueueTimeSamples = properties.getResponseQueueTimeSamples().orElse(ArangoDefaults.DEFAULT_RESPONSE_QUEUE_TIME_SAMPLES);
        this.compression = properties.getCompression().orElse(ArangoDefaults.DEFAULT_COMPRESSION);
        this.compressionThreshold = properties.getCompressionThreshold().orElse(ArangoDefaults.DEFAULT_COMPRESSION_THRESHOLD);
        this.compressionLevel = properties.getCompressionLevel().orElse(ArangoDefaults.DEFAULT_COMPRESSION_LEVEL);
        this.serdeProviderClass = properties.getSerdeProviderClass().map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public List<HostDescription> getHosts() {
        return this.hosts;
    }

    public void addHost(HostDescription hostDescription) {
        this.hosts.add(hostDescription);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setSslCertValue(String sslCertValue) {
        this.sslCertValue = Optional.ofNullable(sslCertValue);
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = Optional.ofNullable(sslAlgorithm);
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSslTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = Optional.ofNullable(sslTrustStorePath);
    }

    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = Optional.ofNullable(sslTrustStorePassword);
    }

    public void setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
    }

    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            this.sslContext = this.createSslContext();
        }
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public Boolean getVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(Boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Boolean getPipelining() {
        return this.pipelining;
    }

    public void setPipelining(Boolean pipelining) {
        this.pipelining = pipelining;
    }

    public Integer getConnectionWindowSize() {
        return this.connectionWindowSize;
    }

    public void setConnectionWindowSize(Integer connectionWindowSize) {
        this.connectionWindowSize = connectionWindowSize;
    }

    public Integer getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(Integer initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public Integer getMaxConnections() {
        if (this.maxConnections == null) {
            this.maxConnections = this.getDefaultMaxConnections();
        }
        return this.maxConnections;
    }

    private int getDefaultMaxConnections() {
        int defaultMaxConnections;
        switch (this.getProtocol()) {
            case VST: {
                defaultMaxConnections = 1;
                break;
            }
            case HTTP_JSON: 
            case HTTP_VPACK: {
                defaultMaxConnections = 20;
                break;
            }
            case HTTP2_JSON: 
            case HTTP2_VPACK: {
                defaultMaxConnections = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return defaultMaxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Long getConnectionTtl() {
        if (this.connectionTtl == null && this.getProtocol() != Protocol.VST) {
            this.connectionTtl = ArangoDefaults.DEFAULT_CONNECTION_TTL_HTTP;
        }
        return this.connectionTtl;
    }

    public void setConnectionTtl(Long connectionTtl) {
        this.connectionTtl = connectionTtl;
    }

    public Integer getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(Integer keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public Boolean getAcquireHostList() {
        return this.acquireHostList;
    }

    public void setAcquireHostList(Boolean acquireHostList) {
        this.acquireHostList = acquireHostList;
    }

    public Integer getAcquireHostListInterval() {
        return this.acquireHostListInterval;
    }

    public void setAcquireHostListInterval(Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
    }

    public LoadBalancingStrategy getLoadBalancingStrategy() {
        return this.loadBalancingStrategy;
    }

    public void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    public Class<? extends ArangoSerdeProvider> getSerdeProviderClass() {
        return this.serdeProviderClass;
    }

    public ArangoSerde getUserDataSerde() {
        if (this.userDataSerde != null) {
            return this.userDataSerde;
        }
        if (this.serdeProviderClass != null) {
            try {
                return this.serdeProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return ArangoSerdeProvider.of(ContentTypeFactory.of(this.getProtocol())).create();
    }

    public InternalSerde getInternalSerde() {
        if (this.internalSerde == null) {
            this.internalSerde = new InternalSerdeProvider(ContentTypeFactory.of(this.getProtocol())).create(this.getUserDataSerde(), this.protocolModule);
        }
        return this.internalSerde;
    }

    public void setUserDataSerde(ArangoSerde userDataSerde) {
        this.userDataSerde = userDataSerde;
    }

    public void setUserDataSerdeProvider(Class<? extends ArangoSerdeProvider> serdeProviderClass) {
        this.serdeProviderClass = serdeProviderClass;
    }

    public Integer getResponseQueueTimeSamples() {
        return this.responseQueueTimeSamples;
    }

    public void setResponseQueueTimeSamples(Integer responseQueueTimeSamples) {
        this.responseQueueTimeSamples = responseQueueTimeSamples;
    }

    public void setProtocolModule(Module m) {
        this.protocolModule = m;
    }

    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public void setAsyncExecutor(Executor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Integer getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(Integer compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public ProtocolConfig getProtocolConfig() {
        return this.protocolConfig;
    }

    public void setProtocolConfig(ProtocolConfig protocolConfig) {
        this.protocolConfig = protocolConfig;
    }

    private SSLContext createSslContext() {
        try {
            if (this.sslCertValue.isPresent()) {
                ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(this.sslCertValue.get()));
                Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(is);
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                ks.setCertificateEntry("arangodb", cert);
                return this.createSslContext(ks);
            }
            if (this.sslTrustStorePath.isPresent()) {
                KeyStore ks = KeyStore.getInstance(this.sslTrustStoreType);
                try (InputStream is = Files.newInputStream(Paths.get(this.sslTrustStorePath.get(), new String[0]), new OpenOption[0]);){
                    ks.load(is, this.sslTrustStorePassword.map(String::toCharArray).orElse(null));
                }
                return this.createSslContext(ks);
            }
            return SSLContext.getDefault();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SSLContext createSslContext(KeyStore ks) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.sslAlgorithm.orElseGet(TrustManagerFactory::getDefaultAlgorithm));
            tmf.init(ks);
            SSLContext sc = SSLContext.getInstance(this.sslProtocol);
            sc.init(null, tmf.getTrustManagers(), null);
            return sc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

