/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.IndexType;
import com.arangodb.entity.VectorIndexParams;
import com.arangodb.model.IndexOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class VectorIndexOptions
extends IndexOptions<VectorIndexOptions> {
    private final IndexType type = IndexType.vector;
    private Iterable<String> fields;
    private Integer parallelism;
    private VectorIndexParams params;
    private Boolean sparse;
    private Collection<String> storedValues;

    @Override
    VectorIndexOptions getThis() {
        return this;
    }

    public Iterable<String> getFields() {
        return this.fields;
    }

    VectorIndexOptions fields(Iterable<String> fields) {
        this.fields = fields;
        return this;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public VectorIndexOptions parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public VectorIndexParams getParams() {
        return this.params;
    }

    public VectorIndexOptions params(VectorIndexParams params) {
        this.params = params;
        return this;
    }

    public Boolean getSparse() {
        return this.sparse;
    }

    public VectorIndexOptions sparse(Boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Collection<String> getStoredValues() {
        return this.storedValues;
    }

    public VectorIndexOptions storedValues(String ... storedValues) {
        if (this.storedValues == null) {
            this.storedValues = new HashSet<String>();
        }
        Collections.addAll(this.storedValues, storedValues);
        return this;
    }

    public IndexType getType() {
        return this.type;
    }
}

