/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.QueueTimeMetrics;
import com.arangodb.model.QueueTimeSample;
import java.util.Arrays;

public class QueueTimeMetricsImpl
implements QueueTimeMetrics {
    private final CircularFifoQueue samples;

    public QueueTimeMetricsImpl(int queueSize) {
        this.samples = new CircularFifoQueue(queueSize);
    }

    @Override
    public QueueTimeSample[] getValues() {
        return this.samples.getElements();
    }

    @Override
    public double getAvg() {
        return this.samples.getAvg();
    }

    void add(double value) {
        this.add(new QueueTimeSample(System.currentTimeMillis(), value));
    }

    void add(QueueTimeSample value) {
        this.samples.add(value);
    }

    void clear() {
        this.samples.clear();
    }

    private static class CircularFifoQueue {
        private final QueueTimeSample[] elements;
        private final int size;
        private int start;
        private int count;
        private double sum;

        CircularFifoQueue(int size) {
            this.elements = new QueueTimeSample[size];
            this.size = this.elements.length;
            this.clear();
        }

        synchronized double getAvg() {
            if (this.count == 0) {
                return 0.0;
            }
            return this.sum / (double)this.count;
        }

        synchronized void clear() {
            this.start = 0;
            this.count = 0;
            this.sum = 0.0;
            Arrays.fill(this.elements, null);
        }

        synchronized void add(QueueTimeSample element) {
            QueueTimeSample overridden;
            if (this.count < this.size) {
                ++this.count;
            }
            if ((overridden = this.elements[this.start]) != null) {
                this.sum -= overridden.value;
            }
            this.elements[this.start++] = element;
            if (this.start >= this.size) {
                this.start = 0;
            }
            this.sum += element.value;
        }

        synchronized QueueTimeSample[] getElements() {
            QueueTimeSample[] out = new QueueTimeSample[this.count];
            if (this.count < this.size) {
                System.arraycopy(this.elements, 0, out, 0, this.count);
            } else {
                System.arraycopy(this.elements, this.start, out, 0, this.size - this.start);
                System.arraycopy(this.elements, 0, out, this.size - this.start, this.start);
            }
            return out;
        }
    }
}

