/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtils.class);

    private JacksonUtils() {
    }

    public static void tryConfigureJsonFactory(Object jf) {
        try {
            JacksonUtils.configureJsonFactory(jf);
        }
        catch (Throwable t) {
            LOG.warn("Got exception while configuring JsonFactory, skipping...", t);
        }
    }

    private static void configureJsonFactory(Object jf) throws Exception {
        if (JacksonUtils.isAtLeastVersion(jf, 2, 15)) {
            LOG.debug("Configuring StreamReadConstraints ...");
            ArrayList<Invocation> readConf = new ArrayList<Invocation>();
            readConf.add(new Invocation("maxNumberLength", Integer.TYPE, Integer.MAX_VALUE));
            readConf.add(new Invocation("maxStringLength", Integer.TYPE, Integer.MAX_VALUE));
            readConf.add(new Invocation("maxNestingDepth", Integer.TYPE, Integer.MAX_VALUE));
            if (JacksonUtils.isAtLeastVersion(jf, 2, 16)) {
                readConf.add(new Invocation("maxNameLength", Integer.TYPE, Integer.MAX_VALUE));
                readConf.add(new Invocation("maxDocumentLength", Long.TYPE, Long.MAX_VALUE));
            } else {
                LOG.debug("Skipping configuring StreamReadConstraints maxNameLength");
                LOG.debug("Skipping configuring StreamReadConstraints maxDocumentLength");
            }
            JacksonUtils.configureStreamConstraints(jf, "StreamReadConstraints", readConf);
        } else {
            LOG.debug("Skipping configuring StreamReadConstraints");
        }
        if (JacksonUtils.isAtLeastVersion(jf, 2, 16)) {
            LOG.debug("Configuring StreamWriteConstraints ...");
            ArrayList<Invocation> writeConf = new ArrayList<Invocation>();
            writeConf.add(new Invocation("maxNestingDepth", Integer.TYPE, Integer.MAX_VALUE));
            JacksonUtils.configureStreamConstraints(jf, "StreamWriteConstraints", writeConf);
        } else {
            LOG.debug("Skipping configuring StreamWriteConstraints");
        }
    }

    private static boolean isAtLeastVersion(Object jf, int major, int minor) throws Exception {
        Class<?> packageVersionClass = Class.forName(jf.getClass().getPackage().getName() + ".json.PackageVersion");
        Object version = packageVersionClass.getDeclaredField("VERSION").get(null);
        Class<?> versionClass = Class.forName(jf.getClass().getPackage().getName() + ".Version");
        int currentMajor = (Integer)versionClass.getDeclaredMethod("getMajorVersion", new Class[0]).invoke(version, new Object[0]);
        int currentMinor = (Integer)versionClass.getDeclaredMethod("getMinorVersion", new Class[0]).invoke(version, new Object[0]);
        LOG.debug("Detected Jackson version: {}.{}", (Object)currentMajor, (Object)currentMinor);
        return currentMajor > major || currentMajor == major && currentMinor >= minor;
    }

    private static void configureStreamConstraints(Object jf, String className, List<Invocation> conf) throws Exception {
        String basePkg = jf.getClass().getPackage().getName();
        Class<?> streamConstraintsClass = Class.forName(basePkg + "." + className);
        Class<?> builderClass = Class.forName(basePkg + "." + className + "$Builder");
        Method buildMethod = builderClass.getDeclaredMethod("build", new Class[0]);
        Method builderMethod = streamConstraintsClass.getDeclaredMethod("builder", new Class[0]);
        Object builder = builderMethod.invoke(null, new Object[0]);
        for (Invocation i : conf) {
            Method method = builderClass.getDeclaredMethod(i.method, i.argType);
            method.invoke(builder, i.arg);
        }
        Object streamReadConstraints = buildMethod.invoke(builder, new Object[0]);
        Method setStreamReadConstraintsMethod = jf.getClass().getDeclaredMethod("set" + className, streamConstraintsClass);
        setStreamReadConstraintsMethod.invoke(jf, streamReadConstraints);
    }

    private static class Invocation {
        final String method;
        final Class<?> argType;
        final Object arg;

        Invocation(String method, Class<?> argType, Object arg) {
            this.method = method;
            this.argType = argType;
            this.arg = arg;
        }
    }
}

