/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.AbstractMDIndexOptions;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionRenameOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.ImportType;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.MDIFieldValueTypes;
import com.arangodb.model.MDIndexOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.util.RawData;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public abstract class InternalArangoCollection
extends ArangoExecuteable {
    protected static final String PATH_API_COLLECTION = "/_api/collection";
    private static final String COLLECTION = "collection";
    private static final String PATH_API_DOCUMENT = "/_api/document";
    private static final String PATH_API_INDEX = "/_api/index";
    private static final String PATH_API_IMPORT = "/_api/import";
    private static final String PATH_API_USER = "/_api/user";
    private static final String MERGE_OBJECTS = "mergeObjects";
    private static final String KEEP_NULL = "keepNull";
    private static final String REFILL_INDEX_CACHES = "refillIndexCaches";
    private static final String VERSION_ATTRIBUTE = "versionAttribute";
    private static final String IGNORE_REVS = "ignoreRevs";
    private static final String RETURN_NEW = "returnNew";
    private static final String RETURN_OLD = "returnOld";
    private static final String OVERWRITE = "overwrite";
    private static final String OVERWRITE_MODE = "overwriteMode";
    private static final String SILENT = "silent";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    protected final String dbName;
    protected final String name;

    protected InternalArangoCollection(ArangoExecuteable executeable, String dbName, String name) {
        super(executeable);
        this.dbName = dbName;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    protected <T> InternalRequest insertDocumentRequest(T value, DocumentCreateOptions options) {
        InternalRequest request = this.createInsertDocumentRequest(options);
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected InternalRequest insertDocumentsRequest(RawData values, DocumentCreateOptions options) {
        InternalRequest request = this.createInsertDocumentRequest(options);
        request.setBody(this.getSerde().serialize(values));
        return request;
    }

    protected <T> InternalRequest insertDocumentsRequest(Iterable<T> values, DocumentCreateOptions options) {
        InternalRequest request = this.createInsertDocumentRequest(options);
        request.setBody(this.getSerde().serializeCollectionUserData(values));
        return request;
    }

    private InternalRequest createInsertDocumentRequest(DocumentCreateOptions options) {
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_DOCUMENT, this.name);
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(OVERWRITE_MODE, params.getOverwriteMode() != null ? params.getOverwriteMode().getValue() : null);
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(KEEP_NULL, params.getKeepNull());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.putQueryParam(VERSION_ATTRIBUTE, params.getVersionAttribute());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocumentsResponseDeserializer(Class<T> userDataClass) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentCreateEntity> docs = new ArrayList<DocumentCreateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            JsonNode body = this.getSerde().parse(response.getBody());
            for (JsonNode next : body) {
                JsonNode isError = next.get("error");
                if (isError != null && isError.booleanValue()) {
                    ErrorEntity error = this.getSerde().deserialize(next, ErrorEntity.class);
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Type type = SerdeUtils.constructParametricType(DocumentCreateEntity.class, userDataClass);
                DocumentCreateEntity doc = (DocumentCreateEntity)this.getSerde().deserialize(next, type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected InternalRequest importDocumentsRequest(RawData values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.auto).setBody(this.getSerde().serialize(values));
    }

    protected InternalRequest importDocumentsRequest(Iterable<?> values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.list).setBody(this.getSerde().serializeCollectionUserData(values));
    }

    protected InternalRequest importDocumentsRequest(DocumentImportOptions options) {
        DocumentImportOptions params = options != null ? options : new DocumentImportOptions();
        return this.request(this.dbName, RequestType.POST, PATH_API_IMPORT).putQueryParam(COLLECTION, this.name).putQueryParam("waitForSync", params.getWaitForSync()).putQueryParam("fromPrefix", params.getFromPrefix()).putQueryParam("toPrefix", params.getToPrefix()).putQueryParam(OVERWRITE, params.getOverwrite()).putQueryParam("onDuplicate", (Object)params.getOnDuplicate()).putQueryParam("complete", params.getComplete()).putQueryParam("details", params.getDetails());
    }

    protected InternalRequest getDocumentRequest(String key, DocumentReadOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.GET, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("if-none-match", params.getIfNoneMatch());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        if (Boolean.TRUE.equals(params.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getDocumentResponseDeserializer(Class<T> type) {
        return response -> this.getSerde().deserializeUserData(response.getBody(), type);
    }

    protected InternalRequest getDocumentsRequest(Iterable<String> keys, DocumentReadOptions options) {
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_DOCUMENT, this.name).putQueryParam("onlyget", true).putHeaderParam("if-none-match", params.getIfNoneMatch()).putHeaderParam("if-match", params.getIfMatch()).setBody(this.getSerde().serialize(keys)).putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        if (Boolean.TRUE.equals(params.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<T>> getDocumentsResponseDeserializer(Class<T> type) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            boolean potentialDirtyRead = Boolean.parseBoolean(response.getMeta("X-Arango-Potential-Dirty-Read"));
            multiDocument.setPotentialDirtyRead(potentialDirtyRead);
            ArrayList docs = new ArrayList();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            JsonNode body = this.getSerde().parse(response.getBody());
            for (JsonNode next : body) {
                JsonNode isError = next.get("error");
                if (isError != null && isError.booleanValue()) {
                    ErrorEntity error = this.getSerde().deserialize(next, ErrorEntity.class);
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Object doc = this.getSerde().deserializeUserData(this.getSerde().serialize(next), type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected <T> InternalRequest replaceDocumentRequest(String key, T value, DocumentReplaceOptions options) {
        InternalRequest request = this.createReplaceDocumentRequest(options, DocumentUtil.createDocumentHandle(this.name, key));
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected <T> InternalRequest replaceDocumentsRequest(Iterable<T> values, DocumentReplaceOptions options) {
        InternalRequest request = this.createReplaceDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serializeCollectionUserData(values));
        return request;
    }

    protected InternalRequest replaceDocumentsRequest(RawData values, DocumentReplaceOptions options) {
        InternalRequest request = this.createReplaceDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serialize(values));
        return request;
    }

    private InternalRequest createReplaceDocumentRequest(DocumentReplaceOptions options, String path) {
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_DOCUMENT, path);
        request.putHeaderParam("if-match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.putQueryParam(VERSION_ATTRIBUTE, params.getVersionAttribute());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocumentsResponseDeserializer(Class<T> returnType) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            JsonNode body = this.getSerde().parse(response.getBody());
            for (JsonNode next : body) {
                JsonNode isError = next.get("error");
                if (isError != null && isError.booleanValue()) {
                    ErrorEntity error = this.getSerde().deserialize(next, ErrorEntity.class);
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Type type = SerdeUtils.constructParametricType(DocumentUpdateEntity.class, returnType);
                DocumentUpdateEntity doc = (DocumentUpdateEntity)this.getSerde().deserialize(next, type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected <T> InternalRequest updateDocumentRequest(String key, T value, DocumentUpdateOptions options) {
        InternalRequest request = this.createUpdateDocumentRequest(options, DocumentUtil.createDocumentHandle(this.name, key));
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected <T> InternalRequest updateDocumentsRequest(Iterable<T> values, DocumentUpdateOptions options) {
        InternalRequest request = this.createUpdateDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serializeCollectionUserData(values));
        return request;
    }

    protected InternalRequest updateDocumentsRequest(RawData values, DocumentUpdateOptions options) {
        InternalRequest request = this.createUpdateDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serialize(values));
        return request;
    }

    private InternalRequest createUpdateDocumentRequest(DocumentUpdateOptions options, String path) {
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        InternalRequest request = this.request(this.dbName, RequestType.PATCH, PATH_API_DOCUMENT, path);
        request.putHeaderParam("if-match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam(KEEP_NULL, params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.putQueryParam(VERSION_ATTRIBUTE, params.getVersionAttribute());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocumentsResponseDeserializer(Class<T> returnType) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            JsonNode body = this.getSerde().parse(response.getBody());
            for (JsonNode next : body) {
                JsonNode isError = next.get("error");
                if (isError != null && isError.booleanValue()) {
                    ErrorEntity error = this.getSerde().deserialize(next, ErrorEntity.class);
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Type type = SerdeUtils.constructParametricType(DocumentUpdateEntity.class, returnType);
                DocumentUpdateEntity doc = (DocumentUpdateEntity)this.getSerde().deserialize(next, type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected InternalRequest deleteDocumentRequest(String key, DocumentDeleteOptions options) {
        return this.createDeleteDocumentRequest(options, DocumentUtil.createDocumentHandle(this.name, key));
    }

    protected <T> InternalRequest deleteDocumentsRequest(Iterable<T> docs, DocumentDeleteOptions options) {
        InternalRequest request = this.createDeleteDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serializeCollectionUserData(docs));
        return request;
    }

    protected InternalRequest deleteDocumentsRequest(RawData docs, DocumentDeleteOptions options) {
        InternalRequest request = this.createDeleteDocumentRequest(options, this.name);
        request.setBody(this.getSerde().serialize(docs));
        return request;
    }

    private InternalRequest createDeleteDocumentRequest(DocumentDeleteOptions options, String path) {
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        InternalRequest request = this.request(this.dbName, RequestType.DELETE, PATH_API_DOCUMENT, path);
        request.putHeaderParam("if-match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocumentsResponseDeserializer(Class<T> userDataClass) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentDeleteEntity> docs = new ArrayList<DocumentDeleteEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            JsonNode body = this.getSerde().parse(response.getBody());
            for (JsonNode next : body) {
                JsonNode isError = next.get("error");
                if (isError != null && isError.booleanValue()) {
                    ErrorEntity error = this.getSerde().deserialize(next, ErrorEntity.class);
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Type type = SerdeUtils.constructParametricType(DocumentDeleteEntity.class, userDataClass);
                DocumentDeleteEntity doc = (DocumentDeleteEntity)this.getSerde().deserialize(next, type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected InternalRequest documentExistsRequest(String key, DocumentExistsOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.HEAD, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentExistsOptions params = options != null ? options : new DocumentExistsOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.putHeaderParam("if-none-match", params.getIfNoneMatch());
        return request;
    }

    protected InternalRequest getIndexRequest(String id) {
        return this.request(this.dbName, RequestType.GET, PATH_API_INDEX, this.createIndexId(id));
    }

    protected InternalRequest deleteIndexRequest(String id) {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_INDEX, this.createIndexId(id));
    }

    protected ArangoExecutor.ResponseDeserializer<String> deleteIndexResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/id", String.class);
    }

    private String createIndexId(String id) {
        String index;
        if (id.matches("[^/]+/[^/]+")) {
            index = id;
        } else if (id.matches("[^/]+")) {
            index = this.name + "/" + id;
        } else {
            throw new ArangoDBException(String.format("index id %s is not valid.", id));
        }
        return index;
    }

    protected InternalRequest createPersistentIndexRequest(Iterable<String> fields, PersistentIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new PersistentIndexOptions(), fields)));
        return request;
    }

    protected InternalRequest createInvertedIndexRequest(InvertedIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(options));
        return request;
    }

    protected InternalRequest createGeoIndexRequest(Iterable<String> fields, GeoIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new GeoIndexOptions(), fields)));
        return request;
    }

    @Deprecated
    protected InternalRequest createFulltextIndexRequest(Iterable<String> fields, FulltextIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new FulltextIndexOptions(), fields)));
        return request;
    }

    protected InternalRequest createTtlIndexRequest(Iterable<String> fields, TtlIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new TtlIndexOptions(), fields)));
        return request;
    }

    protected InternalRequest createZKDIndexRequest(Iterable<String> fields, ZKDIndexOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new ZKDIndexOptions().fieldValueTypes(ZKDIndexOptions.FieldValueTypes.DOUBLE), fields)));
        return request;
    }

    protected InternalRequest createMDIndexRequest(Iterable<String> fields, AbstractMDIndexOptions<?> options) {
        InternalRequest request = this.request(this.dbName, RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        AbstractMDIndexOptions<?> opts = options != null ? options : new MDIndexOptions().fieldValueTypes(MDIFieldValueTypes.DOUBLE);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(opts, fields)));
        return request;
    }

    protected InternalRequest getIndexesRequest() {
        InternalRequest request = this.request(this.dbName, RequestType.GET, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<IndexEntity>> getIndexesResponseDeserializer() {
        return response -> {
            ArrayList<IndexEntity> indexes = new ArrayList<IndexEntity>();
            for (JsonNode idx : this.getSerde().parse(response.getBody(), "/indexes")) {
                if ("inverted".equals(idx.get("type").textValue())) continue;
                indexes.add(this.getSerde().deserialize(idx, IndexEntity.class));
            }
            return indexes;
        };
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<InvertedIndexEntity>> getInvertedIndexesResponseDeserializer() {
        return response -> {
            ArrayList<InvertedIndexEntity> indexes = new ArrayList<InvertedIndexEntity>();
            for (JsonNode idx : this.getSerde().parse(response.getBody(), "/indexes")) {
                if (!"inverted".equals(idx.get("type").textValue())) continue;
                indexes.add(this.getSerde().deserialize(idx, InvertedIndexEntity.class));
            }
            return indexes;
        };
    }

    protected InternalRequest truncateRequest(CollectionTruncateOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_COLLECTION, this.name, "truncate");
        CollectionTruncateOptions params = options != null ? options : new CollectionTruncateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected InternalRequest countRequest(CollectionCountOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.GET, PATH_API_COLLECTION, this.name, "count");
        CollectionCountOptions params = options != null ? options : new CollectionCountOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected InternalRequest dropRequest(Boolean isSystem) {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_COLLECTION, this.name).putQueryParam("isSystem", isSystem);
    }

    protected InternalRequest getInfoRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_COLLECTION, this.name);
    }

    protected InternalRequest getPropertiesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_COLLECTION, this.name, "properties");
    }

    protected InternalRequest changePropertiesRequest(CollectionPropertiesOptions options) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_COLLECTION, this.name, "properties");
        request.setBody(this.getSerde().serialize(options != null ? options : new CollectionPropertiesOptions()));
        return request;
    }

    protected InternalRequest renameRequest(String newName) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_COLLECTION, this.name, "rename");
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(new CollectionRenameOptions(), newName)));
        return request;
    }

    protected <T> InternalRequest responsibleShardRequest(T value) {
        InternalRequest request = this.request(this.dbName, RequestType.PUT, PATH_API_COLLECTION, this.name, "responsibleShard");
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected InternalRequest getRevisionRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_COLLECTION, this.name, "revision");
    }

    protected InternalRequest grantAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", this.dbName, this.name).setBody(this.getSerde().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected InternalRequest resetAccessRequest(String user) {
        return this.request("_system", RequestType.DELETE, PATH_API_USER, user, "database", this.dbName, this.name);
    }

    protected InternalRequest getPermissionsRequest(String user) {
        return this.request("_system", RequestType.GET, PATH_API_USER, user, "database", this.dbName, this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", Permissions.class);
    }
}

