/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoCursorAsync;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoCursor;
import com.arangodb.internal.net.HostHandle;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoCursorAsyncImpl<T>
extends InternalArangoCursor<T>
implements ArangoCursorAsync<T> {
    private final ArangoDatabaseAsyncImpl db;
    private final HostHandle hostHandle;

    public ArangoCursorAsyncImpl(ArangoDatabaseAsyncImpl db, CursorEntity<T> entity, Class<T> type, HostHandle hostHandle, Boolean allowRetry) {
        super(db, db.name(), entity, type, allowRetry);
        this.db = db;
        this.hostHandle = hostHandle;
    }

    @Override
    public CompletableFuture<ArangoCursorAsync<T>> nextBatch() {
        if (Boolean.TRUE.equals(this.hasMore())) {
            return this.executorAsync().execute(this::queryNextRequest, this.db.cursorEntityDeserializer(this.getType()), this.hostHandle).thenApply(r -> new ArangoCursorAsyncImpl(this.db, r, this.getType(), this.hostHandle, (Boolean)this.allowRetry()));
        }
        CompletableFuture<ArangoCursorAsync<T>> cf = new CompletableFuture<ArangoCursorAsync<T>>();
        cf.completeExceptionally(new NoSuchElementException());
        return cf;
    }

    @Override
    public CompletableFuture<Void> close() {
        if (this.getId() != null && (this.allowRetry() || Boolean.TRUE.equals(this.hasMore()))) {
            return ((CompletableFuture)this.executorAsync().execute(this::queryCloseRequest, (Type)((Object)Void.class), this.hostHandle).exceptionally(err -> {
                ArangoDBException aEx;
                Throwable e;
                Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
                if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, 1600)) {
                    return null;
                }
                throw ArangoDBException.of(e);
            })).thenApply(__ -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

