/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http;

import com.arangodb.PackageVersion;
import com.arangodb.arch.UnstableApi;
import com.arangodb.config.HostDescription;
import com.arangodb.http.HttpConnection;
import com.arangodb.http.HttpProtocolConfig;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import io.vertx.core.Vertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public class HttpConnectionFactory
implements ConnectionFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionFactory.class);
    final HttpProtocolConfig protocolConfig;

    public HttpConnectionFactory(@UnstableApi HttpProtocolConfig cfg) {
        HttpProtocolConfig httpProtocolConfig = this.protocolConfig = cfg != null ? cfg : HttpProtocolConfig.builder().build();
        if (this.protocolConfig.getVertx() == null && !PackageVersion.SHADED && Vertx.currentContext() != null) {
            this.LOGGER.warn("Found an existing Vert.x instance, you can reuse it by setting:\nnew ArangoDB.Builder()\n  // ...\n  .protocolConfig(HttpProtocolConfig.builder().vertx(Vertx.currentContext().owner()).build())\n  .build();\n");
        }
    }

    @UnstableApi
    public Connection create(@UnstableApi ArangoConfig config, HostDescription host) {
        return new HttpConnection(config, host, this.protocolConfig);
    }
}

