/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http.compression;

import com.arangodb.Compression;
import com.arangodb.http.compression.NoopEncoder;
import com.arangodb.http.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.vertx.core.buffer.Buffer;

public interface Encoder {
    public Buffer encode(byte[] var1);

    public String getFormat();

    public static Encoder of(Compression compression, int level) {
        if (level < 0 || level > 9) {
            throw new IllegalArgumentException("compression level: " + level + " (expected: 0-9)");
        }
        switch (compression) {
            case GZIP: {
                return new ZlibEncoder(ZlibWrapper.GZIP, level, "gzip");
            }
            case DEFLATE: {
                return new ZlibEncoder(ZlibWrapper.ZLIB, level, "deflate");
            }
            case NONE: {
                return new NoopEncoder();
            }
        }
        throw new IllegalArgumentException("Unsupported compression: " + compression);
    }
}

