/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.serde.jackson.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ContentType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JacksonMapperProvider
extends Supplier<ObjectMapper> {
    public static final Logger LOG = LoggerFactory.getLogger(JacksonMapperProvider.class);

    public static ObjectMapper of(ContentType contentType) {
        String formatName;
        if (contentType == ContentType.JSON) {
            formatName = "JSON";
        } else if (contentType == ContentType.VPACK) {
            formatName = "Velocypack";
        } else {
            throw new IllegalArgumentException("Unexpected value: " + contentType);
        }
        ServiceLoader<JsonFactory> sl = ServiceLoader.load(JsonFactory.class);
        for (JsonFactory jf : sl) {
            if (formatName.equals(jf.getFormatName())) {
                return new ObjectMapper(jf);
            }
            LOG.debug("Required format ({}) not supported by JsonFactory: {}", (Object)formatName, (Object)jf.getClass().getName());
        }
        throw new ArangoDBException("No JsonFactory found for content type: " + contentType);
    }
}

