/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.VPackKeyMapAdapter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public class VPackKeyMapAdapters {
    public static final VPackKeyMapAdapter<String> STRING = new VPackKeyMapAdapter<String>(){

        @Override
        public String serialize(String key) {
            return key;
        }

        @Override
        public String deserialize(String key) {
            return key;
        }
    };
    public static final VPackKeyMapAdapter<Boolean> BOOLEAN = new VPackKeyMapAdapter<Boolean>(){

        @Override
        public String serialize(Boolean key) {
            return key.toString();
        }

        @Override
        public Boolean deserialize(String key) {
            return Boolean.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Integer> INTEGER = new VPackKeyMapAdapter<Integer>(){

        @Override
        public String serialize(Integer key) {
            return key.toString();
        }

        @Override
        public Integer deserialize(String key) {
            return Integer.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Long> LONG = new VPackKeyMapAdapter<Long>(){

        @Override
        public String serialize(Long key) {
            return key.toString();
        }

        @Override
        public Long deserialize(String key) {
            return Long.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Short> SHORT = new VPackKeyMapAdapter<Short>(){

        @Override
        public String serialize(Short key) {
            return key.toString();
        }

        @Override
        public Short deserialize(String key) {
            return Short.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Double> DOUBLE = new VPackKeyMapAdapter<Double>(){

        @Override
        public String serialize(Double key) {
            return key.toString();
        }

        @Override
        public Double deserialize(String key) {
            return Double.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Float> FLOAT = new VPackKeyMapAdapter<Float>(){

        @Override
        public String serialize(Float key) {
            return key.toString();
        }

        @Override
        public Float deserialize(String key) {
            return Float.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<BigInteger> BIG_INTEGER = new VPackKeyMapAdapter<BigInteger>(){

        @Override
        public String serialize(BigInteger key) {
            return key.toString();
        }

        @Override
        public BigInteger deserialize(String key) {
            return new BigInteger(key);
        }
    };
    public static final VPackKeyMapAdapter<BigDecimal> BIG_DECIMAL = new VPackKeyMapAdapter<BigDecimal>(){

        @Override
        public String serialize(BigDecimal key) {
            return key.toString();
        }

        @Override
        public BigDecimal deserialize(String key) {
            return new BigDecimal(key);
        }
    };
    public static final VPackKeyMapAdapter<Number> NUMBER = new VPackKeyMapAdapter<Number>(){

        @Override
        public String serialize(Number key) {
            return key.toString();
        }

        @Override
        public Number deserialize(String key) {
            return Double.valueOf(key);
        }
    };
    public static final VPackKeyMapAdapter<Character> CHARACTER = new VPackKeyMapAdapter<Character>(){

        @Override
        public String serialize(Character key) {
            return key.toString();
        }

        @Override
        public Character deserialize(String key) {
            return Character.valueOf(key.charAt(0));
        }
    };

    private VPackKeyMapAdapters() {
    }

    public static VPackKeyMapAdapter<Enum<?>> createEnumAdapter(final Type type) {
        return new VPackKeyMapAdapter<Enum<?>>(){

            @Override
            public String serialize(Enum<?> key) {
                return key.name();
            }

            @Override
            public Enum<?> deserialize(String key) {
                Class enumType = (Class)type;
                return Enum.valueOf(enumType, key);
            }
        };
    }
}

