/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import java.math.BigInteger;

public class Value {
    private final Object value;
    private final ValueType type;
    private final Class<?> clazz;
    private final boolean unindexed;

    private Value(Object value, ValueType type, Class<?> clazz) {
        this(value, type, clazz, false);
    }

    private Value(Object value, ValueType type, Class<?> clazz, boolean unindexed) {
        this.value = value;
        this.type = type;
        this.clazz = clazz;
        this.unindexed = unindexed;
    }

    public Value(ValueType type) {
        this(type, false);
    }

    public Value(ValueType type, boolean unindexed) throws VPackValueTypeException {
        this(null, type, null, unindexed);
        if (type != ValueType.ARRAY && type != ValueType.OBJECT && type != ValueType.NULL) {
            throw new VPackValueTypeException(ValueType.ARRAY, ValueType.OBJECT, ValueType.NULL);
        }
    }

    public Value(Long value, ValueType type) throws VPackValueTypeException {
        this(value, type, Long.class);
        if (type != ValueType.INT && type != ValueType.UINT && type != ValueType.SMALLINT) {
            throw new VPackValueTypeException(ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
        }
    }

    public Value(BigInteger value, ValueType type) throws VPackValueTypeException {
        this(value, type, BigInteger.class);
        if (type != ValueType.INT && type != ValueType.UINT && type != ValueType.SMALLINT) {
            throw new VPackValueTypeException(ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
        }
    }

    public ValueType getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isUnindexed() {
        return this.unindexed;
    }

    public Number getNumber() {
        return (Number)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public BigInteger getBigInteger() {
        return (BigInteger)this.value;
    }
}

