/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.jumandic.compile;

import com.atilika.kuromoji.compile.TokenInfoDictionaryCompilerBase;
import com.atilika.kuromoji.dict.GenericDictionaryEntry;
import com.atilika.kuromoji.jumandic.compile.DictionaryEntry;
import com.atilika.kuromoji.util.DictionaryEntryLineParser;
import java.util.ArrayList;
import java.util.List;

public class TokenInfoDictionaryCompiler
extends TokenInfoDictionaryCompilerBase<DictionaryEntry> {
    public TokenInfoDictionaryCompiler(String encoding) {
        super(encoding);
    }

    protected DictionaryEntry parse(String line) {
        String[] fields = DictionaryEntryLineParser.parseLine((String)line);
        DictionaryEntry entry = new DictionaryEntry(fields);
        return entry;
    }

    protected GenericDictionaryEntry generateGenericDictionaryEntry(DictionaryEntry entry) {
        List<String> pos = this.extractPosFeatures(entry);
        List<String> features = this.extractOtherFeatures(entry);
        return new GenericDictionaryEntry.Builder().surface(entry.getSurface()).leftId(entry.getLeftId()).rightId(entry.getRightId()).wordCost(entry.getWordCost()).pos(pos).features(features).build();
    }

    public List<String> extractPosFeatures(DictionaryEntry entry) {
        ArrayList<String> posFeatures = new ArrayList<String>();
        posFeatures.add(entry.getPartOfSpeechLevel1());
        posFeatures.add(entry.getPartOfSpeechLevel2());
        posFeatures.add(entry.getPartOfSpeechLevel3());
        posFeatures.add(entry.getPartOfSpeechLevel4());
        return posFeatures;
    }

    public List<String> extractOtherFeatures(DictionaryEntry entry) {
        ArrayList<String> otherFeatures = new ArrayList<String>();
        otherFeatures.add(entry.getBaseForm());
        otherFeatures.add(entry.getReading());
        otherFeatures.add(entry.getSemanticInformation());
        return otherFeatures;
    }
}

