/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.unidic.compile;

import com.atilika.kuromoji.compile.TokenInfoDictionaryCompilerBase;
import com.atilika.kuromoji.dict.GenericDictionaryEntry;
import com.atilika.kuromoji.unidic.compile.DictionaryEntry;
import com.atilika.kuromoji.util.DictionaryEntryLineParser;
import java.util.ArrayList;
import java.util.List;

public class TokenInfoDictionaryCompiler
extends TokenInfoDictionaryCompilerBase<DictionaryEntry> {
    public TokenInfoDictionaryCompiler(String encoding) {
        super(encoding);
    }

    protected DictionaryEntry parse(String line) {
        String[] fields = DictionaryEntryLineParser.parseLine((String)line);
        DictionaryEntry entry = new DictionaryEntry(fields);
        return entry;
    }

    protected GenericDictionaryEntry generateGenericDictionaryEntry(DictionaryEntry entry) {
        List<String> pos = this.extractPosFeatures(entry);
        List<String> features = this.extractOtherFeatures(entry);
        return new GenericDictionaryEntry.Builder().surface(entry.getSurface()).leftId(entry.getLeftId()).rightId(entry.getRightId()).wordCost(entry.getWordCost()).pos(pos).features(features).build();
    }

    public List<String> extractPosFeatures(DictionaryEntry entry) {
        ArrayList<String> posFeatures = new ArrayList<String>();
        posFeatures.add(entry.getPartOfSpeechLevel1());
        posFeatures.add(entry.getPartOfSpeechLevel2());
        posFeatures.add(entry.getPartOfSpeechLevel3());
        posFeatures.add(entry.getPartOfSpeechLevel4());
        posFeatures.add(entry.getConjugationType());
        posFeatures.add(entry.getConjugationForm());
        return posFeatures;
    }

    public List<String> extractOtherFeatures(DictionaryEntry entry) {
        ArrayList<String> otherFeatures = new ArrayList<String>();
        otherFeatures.add(entry.getLemmaReadingForm());
        otherFeatures.add(entry.getLemma());
        otherFeatures.add(entry.getWrittenForm());
        otherFeatures.add(entry.getPronunciation());
        otherFeatures.add(entry.getWrittenBaseForm());
        otherFeatures.add(entry.getPronunciationBaseForm());
        otherFeatures.add(entry.getLanguageType());
        otherFeatures.add(entry.getInitialSoundAlterationType());
        otherFeatures.add(entry.getInitialSoundAlterationForm());
        otherFeatures.add(entry.getFinalSoundAlterationType());
        otherFeatures.add(entry.getFinalSoundAlterationForm());
        return otherFeatures;
    }
}

