/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.ReadOnlyException;
import com.atomikos.util.ClassLoadingHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlBeanWizard {
    private static final String PAR_NAME_PREFIX = "com.atomikos.beans.property.";
    private static final String BOOLEAN_PREFIX = "boolean.";
    private BeanInspector inspector;
    private Map parsedProperties = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;

    private static Property[] filterProperties(Property[] props) throws PropertyException {
        if (props == null) {
            return null;
        }
        ArrayList<Property> list = new ArrayList<Property>();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].isHidden() || props[i].isReadOnly() || props[i].getEditor() == null || props[i].getIndexedProperty() != null) continue;
            list.add(props[i]);
        }
        return list.toArray(new Property[0]);
    }

    public void setClassName(String name) throws ClassNotFoundException {
        Class clazz = ClassLoadingHelper.loadClass(name);
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.inspector = new BeanInspector(bean);
    }

    public String[] getPropertyNames() throws PropertyException {
        ArrayList<String> names = new ArrayList<String>();
        String[] template = new String[]{};
        if (this.inspector == null) {
            return template;
        }
        Property[] props = HtmlBeanWizard.filterProperties(this.inspector.getProperties());
        for (int i = 0; i < props.length; ++i) {
            names.add(props[i].getName());
        }
        return names.toArray(template);
    }

    public Object getPropertyValue(String propertyName) throws PropertyException {
        Object ret = null;
        if (this.parsedProperties.containsKey(propertyName)) {
            ret = this.parsedProperties.get(propertyName);
        } else if (this.inspector != null) {
            Property p = this.inspector.getProperty(propertyName);
            try {
                ret = p.getValue();
            }
            catch (PropertyException readOnly) {
                // empty catch block
            }
        }
        return ret;
    }

    public void showPropertiesInForm(HttpServletResponse response) {
        if (this.inspector == null) {
            return;
        }
        try {
            PrintWriter out = response.getWriter();
            Property[] props = HtmlBeanWizard.filterProperties(this.inspector.getProperties());
            out.println("<table>");
            for (int i = 0; i < props.length; ++i) {
                out.println("<tr>");
                String name = props[i].getName();
                out.println("<td>" + name + "</td>");
                out.println("<td>");
                Class clazz = PrimitiveClasses.getWrapperClass(props[i].getType());
                if (props[i].getAllowedValues() != null) {
                    out.println("<select name=\"com.atomikos.beans.property." + name + "\" >");
                    String[] values = props[i].getAllowedValues();
                    for (int j = 0; j < values.length; ++j) {
                        out.println("<option value=\"" + values[j] + "\">" + values[j]);
                    }
                    out.println("</select>");
                } else if ((class$java$lang$Boolean == null ? HtmlBeanWizard.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(clazz)) {
                    out.println("<input type=\"checkbox\" value=\"true\" name=\"com.atomikos.beans.property.boolean." + name + "\"");
                    try {
                        Boolean b = (Boolean)props[i].getValue();
                        if (b.booleanValue()) {
                            out.println(" checked ");
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    out.println(">");
                } else {
                    out.print("<input type=\"text\" name=\"com.atomikos.beans.property." + name + "\" value=\"");
                    try {
                        Object value = props[i].getValue();
                        out.print(value.toString());
                    }
                    catch (NullPointerException noValue) {
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    out.println("\" >");
                }
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("</table>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseProperties(HttpServletRequest request) throws ServletException, ReadOnlyException {
        if (this.inspector == null) {
            return;
        }
        Enumeration pars = request.getParameterNames();
        this.parsedProperties = new HashMap();
        while (pars.hasMoreElements()) {
            boolean bool = false;
            String name = (String)pars.nextElement();
            if (!name.startsWith(PAR_NAME_PREFIX)) continue;
            String propertyName = name.substring(PAR_NAME_PREFIX.length());
            try {
                if (propertyName.startsWith(BOOLEAN_PREFIX)) {
                    bool = true;
                    propertyName = propertyName.substring(BOOLEAN_PREFIX.length());
                }
                if (request.getParameter(name) != null && !request.getParameter(name).equals("")) {
                    if (!bool) {
                        this.setProperty(propertyName, request.getParameter(name));
                        this.parsedProperties.put(propertyName, request.getParameter(name));
                        continue;
                    }
                    this.setProperty(propertyName, "true");
                    this.parsedProperties.put(propertyName, new Boolean(true));
                    continue;
                }
                if (!bool) continue;
                this.setProperty(propertyName, "false");
                this.parsedProperties.put(propertyName, new Boolean(false));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setProperty(String name, String value) throws ReadOnlyException, PropertyException {
        if (this.inspector == null) {
            throw new IllegalStateException("Not initialized");
        }
        Property p = this.inspector.getProperty(name);
        p.getEditor().setStringValue(value);
        p.setValue(p.getEditor().getEditedObject());
    }
}

