/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.diagnostics;

import com.atomikos.diagnostics.Console;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jConsole
implements Console {
    private static final Logger log = LoggerFactory.getLogger((String)"atomikos");
    private int level;

    public Slf4jConsole() {
        int level = 1;
        if (log.isInfoEnabled()) {
            level = 2;
        } else if (log.isDebugEnabled()) {
            level = 3;
        }
        this.setLevel(level);
    }

    public void close() throws IOException {
    }

    public int getLevel() {
        return this.level;
    }

    public void print(String string) throws IOException {
    }

    public void print(String string, int level) throws IOException {
    }

    public void println(String string) throws IOException {
        this.println(string, 1);
    }

    public void println(String string, int level) throws IOException {
        switch (level) {
            case 1: {
                if (!log.isWarnEnabled()) break;
                log.warn(string);
                break;
            }
            case 2: {
                if (!log.isInfoEnabled()) break;
                log.info(string);
                break;
            }
            case 3: {
                if (!log.isDebugEnabled()) break;
                log.debug(string);
                break;
            }
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

