/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.swing;

import com.atomikos.swing.PropertiesTableModel;
import com.atomikos.swing.PropertyListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertiesPanel
implements ActionListener {
    private static final int NONE_SELECTED = -1;
    private JPanel panel_ = new JPanel();
    private JButton newButton_;
    private JButton deleteButton_;
    private JButton editButton_;
    private PropertiesTableModel model_;
    private Vector listeners_;
    private int currentRow_;

    public PropertiesPanel(PropertiesTableModel model) {
        this(model, false);
    }

    public PropertiesPanel(PropertiesTableModel model, boolean readonly) {
        ResourceBundle messages = ResourceBundle.getBundle("com.atomikos.swing.PropertiesPanelResourceBundle");
        this.panel_.setLayout(new BorderLayout());
        JTable table = new JTable(model.getTableModel());
        Dimension dim = new Dimension(200, 90);
        table.setPreferredScrollableViewportSize(dim);
        JScrollPane scroller = new JScrollPane(table);
        this.panel_.add((Component)scroller, "Center");
        this.model_ = model;
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        this.newButton_ = new JButton(messages.getString("newButtonName"));
        this.newButton_.addActionListener(this);
        this.deleteButton_ = new JButton(messages.getString("deleteButtonName"));
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.addActionListener(this);
        if (!readonly) {
            buttons.add(this.newButton_);
            buttons.add(this.deleteButton_);
            this.editButton_ = new JButton(messages.getString("editButtonName"));
        } else {
            this.editButton_ = new JButton(messages.getString("viewButtonName"));
        }
        this.editButton_.setEnabled(false);
        this.editButton_.addActionListener(this);
        buttons.add(this.editButton_);
        this.panel_.add((Component)buttons, "South");
        this.listeners_ = new Vector();
        this.currentRow_ = -1;
        table.setSelectionMode(0);
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    PropertiesPanel.this.currentRow_ = -1;
                    PropertiesPanel.this.editButton_.setEnabled(false);
                    PropertiesPanel.this.deleteButton_.setEnabled(false);
                } else {
                    PropertiesPanel.this.currentRow_ = lsm.getMinSelectionIndex();
                    PropertiesPanel.this.editButton_.setEnabled(true);
                    PropertiesPanel.this.deleteButton_.setEnabled(true);
                }
            }
        });
    }

    public synchronized void actionPerformed(ActionEvent e) {
        int i = -1;
        if (e.getSource() == this.newButton_) {
            i = 0;
        } else if (e.getSource() == this.editButton_) {
            i = 1;
        } else if (e.getSource() == this.deleteButton_) {
            i = 2;
        }
        Enumeration enumm = this.listeners_.elements();
        while (enumm.hasMoreElements()) {
            PropertyListener l = (PropertyListener)enumm.nextElement();
            switch (i) {
                case 0: {
                    l.newProperty(this.model_);
                    break;
                }
                case 1: {
                    l.editProperty(this.model_, this.currentRow_);
                    break;
                }
                case 2: {
                    l.deleteProperty(this.model_, this.currentRow_);
                    this.deleteButton_.setEnabled(false);
                    this.editButton_.setEnabled(false);
                    break;
                }
            }
        }
    }

    public synchronized void addPropertyListener(PropertyListener l) {
        this.listeners_.addElement(l);
    }

    public synchronized void removePropertyListener(PropertyListener l) {
        this.listeners_.remove(l);
    }

    public JPanel getPanel() {
        return this.panel_;
    }
}

