/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.xa.event.XAResourceDetectedEvent;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.AtomikosXAConnectionFactory;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.util.ClassLoadingHelper;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.XADataSource;

public class AtomikosDataSourceBean
extends AbstractDataSourceBean {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosDataSourceBean.class);
    private static final long serialVersionUID = 1L;
    private Properties xaProperties = new Properties();
    private String xaDataSourceClassName;
    private transient XADataSource xaDataSource;

    private String printXaProperties() {
        StringBuffer ret = new StringBuffer();
        if (this.xaProperties != null) {
            Set<String> names = this.xaProperties.stringPropertyNames();
            ret.append("[");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    ret.append(",");
                }
                String value = this.xaProperties.getProperty(name);
                ret.append(name);
                ret.append("=");
                ret.append(value);
                first = false;
            }
            ret.append("]");
        }
        return ret.toString();
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public void setXaDataSourceClassName(String xaDataSourceClassName) {
        this.xaDataSourceClassName = xaDataSourceClassName;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    protected ConnectionFactory doInit() throws Exception {
        if (this.xaDataSource == null) {
            if (this.xaDataSourceClassName == null) {
                this.throwAtomikosSQLException("Property 'xaDataSourceClassName' cannot be null");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosSQLException("Property 'xaProperties' cannot be null");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": initializing with [" + " xaDataSourceClassName=" + this.xaDataSourceClassName + "," + " uniqueResourceName=" + this.getUniqueResourceName() + "," + " maxPoolSize=" + this.getMaxPoolSize() + "," + " minPoolSize=" + this.getMinPoolSize() + "," + " borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + "," + " maxIdleTime=" + this.getMaxIdleTime() + "," + " reapTimeout=" + this.getReapTimeout() + "," + " maintenanceInterval=" + this.getMaintenanceInterval() + "," + " testQuery=" + this.getTestQuery() + "," + " xaProperties=" + this.printXaProperties() + "," + " loginTimeout=" + this.getLoginTimeout() + "," + " maxLifetime=" + this.getMaxLifetime() + "]");
        }
        if (this.xaDataSource == null) {
            try {
                Class xadsClass = ClassLoadingHelper.loadClass((String)this.getXaDataSourceClassName());
                this.xaDataSource = (XADataSource)xadsClass.newInstance();
            }
            catch (ClassNotFoundException nf) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' could not be found in the classpath. Please make sure the spelling is correct, and that the required jar(s) are in the classpath.", nf);
            }
            catch (ClassCastException cce) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' does not implement the required interface javax.jdbc.XADataSource. Please make sure the spelling is correct, and check your JDBC driver vendor's documentation.");
            }
            this.xaDataSource.setLoginTimeout(this.getLoginTimeout());
            this.xaDataSource.setLogWriter(this.getLogWriter());
            PropertyUtils.setProperties((Object)this.xaDataSource, (Map)this.xaProperties);
        }
        JdbcTransactionalResource tr = new JdbcTransactionalResource(this.getUniqueResourceName(), this.xaDataSource);
        AtomikosXAConnectionFactory cf = new AtomikosXAConnectionFactory(this.xaDataSource, tr, this);
        Configuration.addResource((RecoverableResource)tr);
        EventPublisher.publish((Event)new XAResourceDetectedEvent(this.xaDataSourceClassName, this.xaProperties, XAResourceDetectedEvent.ResourceType.JDBC));
        return cf;
    }

    @Override
    protected void doClose() {
        RecoverableResource res = Configuration.getResource((String)this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource((String)this.getUniqueResourceName());
            res.close();
        }
    }

    public String toString() {
        String ret = "AtomikosDataSoureBean";
        String name = this.getUniqueResourceName();
        if (name != null) {
            ret = ret + " '" + name + "'";
        }
        return ret;
    }

    @Override
    protected boolean isAssignableFromWrappedVendorClass(Class<?> iface) {
        boolean ret = false;
        if (this.xaDataSource != null) {
            ret = iface.isAssignableFrom(this.xaDataSource.getClass());
        }
        return ret;
    }

    @Override
    protected Object unwrapVendorInstance() {
        return this.xaDataSource;
    }
}

