/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceTransaction
implements ResourceTransaction,
Externalizable,
Participant {
    static final long serialVersionUID = -8227293322090019196L;
    protected String tid_;
    protected String root_;
    private boolean isXaSuspended_;
    protected TxState state_;
    protected String resourcename_;
    protected transient Xid xid_;
    protected transient XATransactionalResource resource_;
    protected transient XAResource xaresource_;
    protected transient CompositeTransaction transaction_;
    protected Vector heuristicMessages_;
    protected transient boolean enlisted_;
    protected transient int timeout_;

    protected static String interpretErrorCode(String resourceName, String opCode, Xid xid, int errorCode) {
        String msg = "unkown";
        switch (errorCode) {
            case -7: {
                msg = "the XA resource has become unavailable";
                break;
            }
            case 100: {
                msg = "the XA resource has rolled back for an unspecified reason";
                break;
            }
            case 101: {
                msg = "the XA resource rolled back due to a communication failure";
                break;
            }
            case 102: {
                msg = "the XA resource has rolled back because of a deadlock";
                break;
            }
            case 103: {
                msg = "the XA resource has rolled back due to a constraint violation";
                break;
            }
            case 104: {
                msg = "the XA resource has rolled back for an unknown reason";
                break;
            }
            case 105: {
                msg = "the XA resource has rolled back because it did not expect this command in the current context";
                break;
            }
            case 106: {
                msg = "the XA resource has rolled back because the transaction took too long";
                break;
            }
            case 107: {
                msg = "the XA resource has rolled back for a temporary reason - the transaction can be retried later";
                break;
            }
            case 9: {
                msg = "XA resume attempted in a different place from where suspend happened";
                break;
            }
            case 8: {
                msg = "the XA resource may have heuristically completed the transaction";
                break;
            }
            case 7: {
                msg = "the XA resource has heuristically committed";
                break;
            }
            case 6: {
                msg = "the XA resource has heuristically rolled back";
                break;
            }
            case 5: {
                msg = "the XA resource has heuristically committed some parts and rolled back other parts";
                break;
            }
            case 4: {
                msg = "the XA command had no effect and may be retried";
                break;
            }
            case 3: {
                msg = "the XA resource had no updates to perform for this transaction";
                break;
            }
            case -3: {
                msg = "the XA resource detected an internal error";
                break;
            }
            case -4: {
                msg = "the supplied XID is invalid for this XA resource";
                break;
            }
            case -5: {
                msg = "invalid arguments were given for the XA operation";
                break;
            }
            case -6: {
                msg = "the XA resource did not expect this command in the current context";
                break;
            }
            case -8: {
                msg = "the supplied XID already exists in this XA resource";
                break;
            }
            case -9: {
                msg = "the XA resource is currently involved in a local (non-XA) transaction";
                break;
            }
            default: {
                msg = "unknown";
            }
        }
        return "XA resource '" + resourceName + "': " + opCode + " for XID '" + XAResourceTransaction.xidToHexString(xid) + "' raised " + errorCode + ": " + msg;
    }

    public XAResourceTransaction() {
    }

    XAResourceTransaction(XATransactionalResource resource, CompositeTransaction transaction, String root) {
        this.resource_ = resource;
        this.transaction_ = transaction;
        TransactionControl control = transaction.getTransactionControl();
        if (control != null) {
            this.timeout_ = (int)transaction.getTransactionControl().getTimeout() / 1000;
        }
        this.tid_ = transaction.getTid();
        this.root_ = root;
        this.resourcename_ = resource.getName();
        this.xid_ = this.resource_.createXid(this.tid_);
        this.state_ = TxState.ACTIVE;
        this.heuristicMessages_ = new Vector();
        this.isXaSuspended_ = false;
        this.enlisted_ = false;
        this.addHeuristicMessage((HeuristicMessage)new StringHeuristicMessage("XA resource '" + resource.getName() + "' accessed with Xid '" + XAResourceTransaction.xidToHexString(this.xid_) + "'"));
    }

    private static String xidToHexString(Xid xid) {
        String gtrid = XAResourceTransaction.byteArrayToHexString(xid.getGlobalTransactionId());
        String bqual = XAResourceTransaction.byteArrayToHexString(xid.getBranchQualifier());
        return gtrid + ":" + bqual;
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            String hexByte = Integer.toHexString(byteArray[i]);
            sb.append(hexByte);
        }
        return sb.toString().toUpperCase();
    }

    private void switchToHeuristicState(String opCode, TxState state, XAException cause) {
        String errorMsg = XAResourceTransaction.interpretErrorCode(this.resourcename_, opCode, this.xid_, cause.errorCode);
        this.addHeuristicMessage((HeuristicMessage)new StringHeuristicMessage(errorMsg));
        this.state_ = state;
    }

    protected void testOrRefreshXAResourceFor2PC() {
        try {
            if (this.state_.equals((Object)TxState.HEUR_HAZARD)) {
                this.forceRefreshXAConnection();
            } else if (this.xaresource_ != null) {
                this.xaresource_.isSameRM(this.xaresource_);
            }
        }
        catch (XAException xa) {
            Configuration.logDebug((String)(this.resourcename_ + ": XAResource needs refresh"), (Throwable)xa);
            this.xaresource_ = this.resource_.getXAResource();
        }
    }

    protected void forceRefreshXAConnection() {
        Configuration.logDebug((String)(this.resourcename_ + ": forcing refresh of XAConnection..."));
        try {
            this.xaresource_ = this.resource_.refreshXAConnection();
        }
        catch (ResourceException re) {
            Configuration.logWarning((String)(this.resourcename_ + ": could not refresh XAConnection"), (Throwable)re);
        }
    }

    protected void printMsg(String msg, int level) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(msg, level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void terminateInResource() {
        if (this.resource_ != null) {
            this.resource_.removeSiblingMap(this.root_);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.xid_);
        out.writeObject(this.tid_);
        out.writeObject(this.root_);
        out.writeObject(this.state_);
        out.writeObject(this.heuristicMessages_.clone());
        out.writeObject(this.resourcename_);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid_ = (Xid)in.readObject();
        this.tid_ = (String)in.readObject();
        this.root_ = (String)in.readObject();
        this.state_ = (TxState)in.readObject();
        this.heuristicMessages_ = (Vector)in.readObject();
        this.resourcename_ = (String)in.readObject();
    }

    public String getTid() {
        return this.tid_;
    }

    public void addCompensationContext(Dictionary context) throws IllegalStateException {
    }

    public void addHeuristicMessage(HeuristicMessage mesg) throws IllegalStateException {
        this.heuristicMessages_.addElement(mesg);
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] heurArray = new HeuristicMessage[1];
        return this.heuristicMessages_.toArray(heurArray);
    }

    public Dictionary getCompensationContext() {
        return null;
    }

    public synchronized void suspend() throws ResourceException {
        Stack<XAException> errors = new Stack<XAException>();
        if (this.state_.equals((Object)TxState.ACTIVE)) {
            try {
                this.printMsg("XAResource.end ( " + XAResourceTransaction.xidToHexString(this.xid_) + " , XAResource.TMSUCCESS ) on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
                this.xaresource_.end(this.xid_, 0x4000000);
            }
            catch (XAException xaerr) {
                errors.push(xaerr);
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "end", this.xid_, xaerr.errorCode);
                Configuration.logDebug((String)msg, (Throwable)xaerr);
                throw new ResourceException(msg, errors);
            }
            this.state_ = TxState.LOCALLY_DONE;
        }
    }

    public synchronized void resume() throws ResourceException {
        int flag = 0;
        Stack<XAException> errors = new Stack<XAException>();
        String logFlag = "";
        if (this.state_.equals((Object)TxState.LOCALLY_DONE)) {
            flag = 0x200000;
            logFlag = "XAResource.TMJOIN";
        } else if (!this.enlisted_) {
            flag = 0;
            logFlag = "XAResource.TMNOFLAGS";
        } else {
            throw new IllegalStateException("Wrong state for resume: " + this.state_);
        }
        try {
            this.printMsg("XAResource.start ( " + XAResourceTransaction.xidToHexString(this.xid_) + " , " + logFlag + " ) on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            this.xaresource_.start(this.xid_, flag);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "resume", this.xid_, xaerr.errorCode);
            Configuration.logWarning((String)msg, (Throwable)xaerr);
            errors.push(xaerr);
            throw new ResourceException(msg, errors);
        }
        this.state_ = TxState.ACTIVE;
        this.enlisted_ = true;
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
    }

    public Object getState() {
        return this.state_;
    }

    public boolean recover() throws SysException {
        boolean recovered = false;
        if (TxState.ACTIVE.equals((Object)this.state_) || TxState.LOCALLY_DONE.equals((Object)this.state_)) {
            return false;
        }
        Enumeration resources = Configuration.getResources();
        while (resources.hasMoreElements()) {
            RecoverableResource res = (RecoverableResource)resources.nextElement();
            if (!res.recover((Participant)this)) continue;
            recovered = true;
        }
        this.enlisted_ = true;
        return recovered;
    }

    public void setGlobalSiblingCount(int count) {
    }

    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource_ != null) {
                this.xaresource_.forget(this.xid_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state_ = TxState.TERMINATED;
    }

    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 0;
        Stack<XAException> errors = new Stack<XAException>();
        this.terminateInResource();
        if (TxState.ACTIVE.equals((Object)this.state_)) {
            this.suspend();
        }
        if (this.state_.equals((Object)TxState.IN_DOUBT)) {
            return 0;
        }
        if (!this.state_.equals((Object)TxState.LOCALLY_DONE)) {
            throw new SysException("Wrong state for prepare: " + this.state_);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("About to call prepare on XAResource instance: " + this.xaresource_, 3);
            ret = this.xaresource_.prepare(this.xid_);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "prepare", this.xid_, xaerr.errorCode);
            Configuration.logDebug((String)msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                throw new RollbackException(msg);
            }
            errors.push(xaerr);
            throw new SysException(msg, errors);
        }
        this.state_ = TxState.IN_DOUBT;
        if (ret == 3) {
            this.printMsg("XAResource.prepare ( " + XAResourceTransaction.xidToHexString(this.xid_) + " ) returning XAResource.XA_RDONLY " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            return 0;
        }
        this.printMsg("XAResource.prepare ( " + XAResourceTransaction.xidToHexString(this.xid_) + " ) returning OK " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
        return 1;
    }

    public synchronized HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        Stack<Throwable> errors = new Stack<Throwable>();
        this.terminateInResource();
        if (!this.enlisted_) {
            return null;
        }
        if (this.state_.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state_.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException(this.getHeuristicMessages());
        }
        if (this.xaresource_ == null) {
            Configuration.logWarning((String)("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback - the required resource is probably not yet intialized?"));
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (this.state_.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("XAResource.rollback ( " + XAResourceTransaction.xidToHexString(this.xid_) + " ) " + "on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            this.xaresource_.rollback(this.xid_);
        }
        catch (ResourceException resErr) {
            errors.push(resErr);
            throw new SysException("Error in rollback: " + resErr.getMessage(), errors);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "rollback", this.xid_, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                Configuration.logDebug((String)msg);
            }
            Configuration.logWarning((String)msg, (Throwable)xaerr);
            switch (xaerr.errorCode) {
                case 8: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_HAZARD, xaerr);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_MIXED, xaerr);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_COMMITTED, xaerr);
                    throw new HeurCommitException(this.getHeuristicMessages());
                }
                case 6: {
                    this.forget();
                    break;
                }
                case -4: {
                    this.printMsg("XAResource.rollback: invalid Xid - already rolled back in resource?", 3);
                    this.state_ = TxState.TERMINATED;
                    break;
                }
                default: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_HAZARD, xaerr);
                    errors.push(xaerr);
                    throw new SysException(msg, errors);
                }
            }
        }
        this.state_ = TxState.TERMINATED;
        return this.getHeuristicMessages();
    }

    public synchronized HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        Stack<XAException> errors = new Stack<XAException>();
        this.terminateInResource();
        if (this.state_.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state_.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state_.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException(this.getHeuristicMessages());
        }
        if (this.xaresource_ == null) {
            Configuration.logWarning((String)("XAResourceTransaction " + this.getXid() + ": no XAResource to commit - the required resource is probably not yet intialized?"));
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (TxState.ACTIVE.equals((Object)this.state_)) {
                this.suspend();
            }
        }
        catch (ResourceException re) {
            throw new RollbackException(re.getMessage());
        }
        if (!(this.state_.equals((Object)TxState.LOCALLY_DONE) || this.state_.equals((Object)TxState.IN_DOUBT) || this.state_.equals((Object)TxState.HEUR_HAZARD))) {
            throw new SysException("Wrong state for commit: " + this.state_);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            this.printMsg("XAResource.commit ( " + XAResourceTransaction.xidToHexString(this.xid_) + " , " + onePhase + " ) on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            this.xaresource_.commit(this.xid_, onePhase);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "commit", this.xid_, xaerr.errorCode);
            Configuration.logWarning((String)msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                errors.push(xaerr);
                if (!onePhase) {
                    throw new SysException(msg, errors);
                }
                throw new RollbackException("Already rolled back in resource.");
            }
            switch (xaerr.errorCode) {
                case 8: {
                    this.switchToHeuristicState("commit", TxState.HEUR_HAZARD, xaerr);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.switchToHeuristicState("commit", TxState.HEUR_MIXED, xaerr);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.switchToHeuristicState("commit", TxState.HEUR_ABORTED, xaerr);
                    throw new HeurRollbackException(this.getHeuristicMessages());
                }
                case -4: {
                    if (!onePhase) {
                        this.printMsg("XAResource.commit: invalid Xid - transaction already committed in resource?", 1);
                        this.state_ = TxState.TERMINATED;
                        break;
                    }
                }
                default: {
                    this.switchToHeuristicState("commit", TxState.HEUR_HAZARD, xaerr);
                    errors.push(xaerr);
                    throw new SysException(msg, errors);
                }
            }
        }
        this.state_ = TxState.TERMINATED;
        return this.getHeuristicMessages();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction other = (XAResourceTransaction)o;
        return this.xid_.equals(other.xid_);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "XAResourceTransaction: " + XAResourceTransaction.xidToHexString(this.xid_);
    }

    public Xid getXid() {
        return this.xid_;
    }

    protected void setRecoveredXAResource(XAResource xaresource) {
        if (!TxState.ACTIVE.equals((Object)this.state_)) {
            this.setXAResource(xaresource);
        }
    }

    public void setXAResource(XAResource xaresource) {
        Configuration.logDebug((String)(this + ": about to switch to XAResource " + xaresource));
        this.xaresource_ = xaresource;
        try {
            this.xaresource_.setTransactionTimeout(this.timeout_);
        }
        catch (XAException e) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "setTransactionTimeout", this.xid_, e.errorCode);
            Configuration.logWarning((String)msg, (Throwable)e);
        }
        Configuration.logDebug((String)("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xaresource));
    }

    public void xaSuspend() throws XAException {
        if (!this.isXaSuspended_) {
            try {
                this.printMsg("XAResource.suspend ( " + XAResourceTransaction.xidToHexString(this.xid_) + " , XAResource.TMSUSPEND ) on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
                this.xaresource_.end(this.xid_, 0x2000000);
                this.isXaSuspended_ = true;
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "suspend", this.xid_, xaerr.errorCode);
                Configuration.logWarning((String)msg, (Throwable)xaerr);
                throw xaerr;
            }
        }
    }

    public void xaResume() throws XAException {
        try {
            this.printMsg("XAResource.start ( " + XAResourceTransaction.xidToHexString(this.xid_) + " , XAResource.TMRESUME ) on resource " + this.resourcename_ + " represented by XAResource instance " + this.xaresource_, 2);
            this.xaresource_.start(this.xid_, 0x8000000);
            this.isXaSuspended_ = false;
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename_, "resume", this.xid_, xaerr.errorCode);
            Configuration.logWarning((String)msg, (Throwable)xaerr);
            throw xaerr;
        }
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended_;
    }

    public boolean isActive() {
        return this.state_.equals((Object)TxState.ACTIVE);
    }

    public String getURI() {
        return null;
    }
}

