/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Iterator;

public class ConnectionPoolWithSynchronizedValidation<ConnectionType>
extends ConnectionPool<ConnectionType> {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConnectionPoolWithSynchronizedValidation.class);

    public ConnectionPoolWithSynchronizedValidation(ConnectionFactory<ConnectionType> connectionFactory, ConnectionPoolProperties properties) throws ConnectionPoolException {
        super(connectionFactory, properties);
    }

    @Override
    public synchronized ConnectionType borrowConnection() throws CreateConnectionException, PoolExhaustedException, ConnectionPoolException {
        return super.borrowConnection();
    }

    @Override
    protected ConnectionType recycleConnectionIfPossible() throws Exception {
        ConnectionType ret = null;
        for (int i = 0; i < this.totalSize(); ++i) {
            XPooledConnection xpc = (XPooledConnection)this.connections.get(i);
            if (!xpc.canBeRecycledForCallingThread()) continue;
            ret = xpc.createConnectionProxy();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": recycling connection from pool...");
            }
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionType retrieveFirstAvailableConnection() {
        ConnectionType ret = null;
        Iterator it = this.connections.iterator();
        while (it.hasNext() && ret == null) {
            XPooledConnection xpc = (XPooledConnection)it.next();
            if (!xpc.isAvailable()) continue;
            try {
                ret = xpc.createConnectionProxy();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.logTrace(this + ": got connection from pool");
            }
            catch (CreateConnectionException ex) {
                String msg = this + ": error creating proxy of connection " + xpc;
                LOGGER.logDebug(msg, (Throwable)ex);
                it.remove();
                this.destroyPooledConnection(xpc, false);
            }
            finally {
                this.logCurrentPoolSize();
            }
        }
        return ret;
    }
}

