/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.pool.XPooledConnectionEventListener;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.logging.StackTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractXPooledConnection<ConnectionType>
implements XPooledConnection<ConnectionType> {
    private static final Logger LOGGER = LoggerFactory.createLogger(AbstractXPooledConnection.class);
    private static boolean collectStackTraceForNextReap = false;
    private long lastTimeAcquired = System.currentTimeMillis();
    private long lastTimeReleased = System.currentTimeMillis();
    private List<XPooledConnectionEventListener<ConnectionType>> poolEventListeners = new ArrayList<XPooledConnectionEventListener<ConnectionType>>();
    private ConnectionType currentProxy = null;
    private ConnectionPoolProperties props;
    private long creationTime = System.currentTimeMillis();
    private final AtomicBoolean isConcurrentlyBeingAcquired = new AtomicBoolean(false);
    private final long maxLifetimeInMillis;
    private StackTraceElement[] stackTrace;

    protected AbstractXPooledConnection(ConnectionPoolProperties props) {
        this.props = props;
        this.maxLifetimeInMillis = props.getMaxLifetime() * 1000;
    }

    protected void processStackTrace() {
        if (this.stackTrace != null) {
            LOGGER.logWarning(this + ": reaping connection - see stacktrace below for how the connection was last acquired (if there is a connection leak then this may help you find it in your application-specific part of this stack trace)");
            LOGGER.logWarning(StackTrace.toString(this.stackTrace));
        } else {
            LOGGER.logWarning(this + ": reaping connection (and starting to collect stack traces for next reap)...");
            collectStackTraceForNextReap = true;
        }
    }

    @Override
    public long getLastTimeAcquired() {
        return this.lastTimeAcquired;
    }

    @Override
    public long getLastTimeReleased() {
        return this.lastTimeReleased;
    }

    @Override
    public synchronized ConnectionType createConnectionProxy() throws CreateConnectionException {
        if (collectStackTraceForNextReap) {
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
        this.updateLastTimeAcquired();
        this.testUnderlyingConnection();
        this.currentProxy = this.doCreateConnectionProxy();
        this.isConcurrentlyBeingAcquired.set(false);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": returning proxy " + this.currentProxy);
        }
        return this.currentProxy;
    }

    @Override
    public void registerXPooledConnectionEventListener(XPooledConnectionEventListener<ConnectionType> listener) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": registering listener " + listener);
        }
        this.poolEventListeners.add(listener);
    }

    @Override
    public void unregisterXPooledConnectionEventListener(XPooledConnectionEventListener<ConnectionType> listener) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": unregistering listener " + listener);
        }
        this.poolEventListeners.remove(listener);
    }

    protected void fireOnXPooledConnectionTerminated() {
        for (int i = 0; i < this.poolEventListeners.size(); ++i) {
            XPooledConnectionEventListener<ConnectionType> listener = this.poolEventListeners.get(i);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": notifying listener: " + listener);
            }
            listener.onXPooledConnectionTerminated(this);
        }
        this.updateLastTimeReleased();
    }

    protected String getTestQuery() {
        return this.props.getTestQuery();
    }

    protected void updateLastTimeReleased() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": updating last time released");
        }
        this.lastTimeReleased = System.currentTimeMillis();
    }

    private void updateLastTimeAcquired() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": updating last time acquired");
        }
        this.lastTimeAcquired = System.currentTimeMillis();
    }

    protected ConnectionType getCurrentConnectionProxy() {
        return this.currentProxy;
    }

    @Override
    public boolean canBeRecycledForCallingThread() {
        return false;
    }

    protected int getDefaultIsolationLevel() {
        return this.props.getDefaultIsolationLevel();
    }

    protected int getBorrowConnectionTimeout() {
        return this.props.getBorrowConnectionTimeout();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markAsBeingAcquiredIfAvailable() {
        AtomicBoolean atomicBoolean = this.isConcurrentlyBeingAcquired;
        synchronized (atomicBoolean) {
            if (this.isConcurrentlyBeingAcquired.get()) {
                return false;
            }
            this.isConcurrentlyBeingAcquired.set(this.isAvailable());
            return this.isConcurrentlyBeingAcquired.get();
        }
    }

    protected abstract ConnectionType doCreateConnectionProxy() throws CreateConnectionException;

    protected abstract void testUnderlyingConnection() throws CreateConnectionException;

    protected boolean maxLifetimeExceeded() {
        boolean ret = false;
        if (this.maxLifetimeInMillis > 0L) {
            ret = this.getCreationTime() + this.maxLifetimeInMillis < System.currentTimeMillis();
        }
        return ret;
    }

    @Override
    public synchronized void destroy(boolean reap) {
        if (reap) {
            this.processStackTrace();
        } else if (!this.isAvailable()) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": destroying...");
        }
        this.doDestroy(reap);
    }

    protected abstract void doDestroy(boolean var1);
}

