/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.ConnectionPoolWithConcurrentValidation;
import com.atomikos.datasource.pool.ConnectionPoolWithSynchronizedValidation;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.icatch.OrderedLifecycleComponent;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jms.SessionCreationMode;
import com.atomikos.jms.internal.AtomikosJMSException;
import com.atomikos.jms.internal.AtomikosPooledJmsConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.IntraVmObjectFactory;
import com.atomikos.util.IntraVmObjectRegistry;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class AtomikosConnectionFactoryBean
implements ConnectionFactory,
ConnectionPoolProperties,
Referenceable,
Serializable,
OrderedLifecycleComponent {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionFactoryBean.class);
    private static final long serialVersionUID = 1L;
    private String uniqueResourceName;
    private int maxPoolSize = 1;
    private int minPoolSize = 1;
    private String xaConnectionFactoryClassName;
    private int borrowConnectionTimeout = 30;
    private Properties xaProperties = new Properties();
    private transient ConnectionPool<Connection> connectionPool;
    private transient XAConnectionFactory xaConnectionFactory;
    private int maintenanceInterval = 60;
    private int maxIdleTime = 60;
    private boolean localTransactionMode;
    private int maxLifetime = 0;
    private boolean enableConcurrentConnectionValidation = true;
    private int sessionCreationMode = SessionCreationMode.JMS_2_0;

    private void throwAtomikosJMSException(String msg) throws AtomikosJMSException {
        this.throwAtomikosJMSException(msg, null);
    }

    private void throwAtomikosJMSException(String msg, Throwable cause) throws AtomikosJMSException {
        AtomikosJMSException.throwAtomikosJMSException(msg, cause);
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setPoolSize(int minAndMaxSize) {
        this.setMinPoolSize(minAndMaxSize);
        this.setMaxPoolSize(minAndMaxSize);
    }

    @Override
    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    public void setUniqueResourceName(String resourceName) {
        this.uniqueResourceName = resourceName;
    }

    public String getXaConnectionFactoryClassName() {
        return this.xaConnectionFactoryClassName;
    }

    public void setXaConnectionFactoryClassName(String xaConnectionFactoryClassName) {
        this.xaConnectionFactoryClassName = xaConnectionFactoryClassName;
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    @Override
    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public synchronized void init() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": init...");
        }
        if (this.connectionPool != null) {
            return;
        }
        if (this.maxPoolSize < 1) {
            this.throwAtomikosJMSException("Property 'maxPoolSize' of class AtomikosConnectionFactoryBean must be greater than 0, was: " + this.maxPoolSize);
        }
        if (this.minPoolSize < 0 || this.minPoolSize > this.maxPoolSize) {
            this.throwAtomikosJMSException("Property 'minPoolSize' of class AtomikosConnectionFactoryBean must be at least 0 and at most maxPoolSize, was: " + this.minPoolSize);
        }
        if (this.getUniqueResourceName() == null) {
            this.throwAtomikosJMSException("Property 'uniqueResourceName' of class AtomikosConnectionFactoryBean cannot be null.");
        }
        try {
            com.atomikos.datasource.pool.ConnectionFactory<Connection> cf = this.doInit();
            this.connectionPool = this.enableConcurrentConnectionValidation ? new ConnectionPoolWithConcurrentValidation<Connection>(cf, this) : new ConnectionPoolWithSynchronizedValidation<Connection>(cf, this);
            this.getReference();
        }
        catch (AtomikosJMSException e) {
            throw e;
        }
        catch (Exception ex) {
            this.throwAtomikosJMSException("Cannot initialize AtomikosConnectionFactoryBean", ex);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": init done.");
        }
    }

    private com.atomikos.datasource.pool.ConnectionFactory<Connection> doInit() throws Exception {
        if (this.xaConnectionFactory == null) {
            if (this.xaConnectionFactoryClassName == null) {
                this.throwAtomikosJMSException("Property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean cannot be null.");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosJMSException("Property 'xaProperties' of class AtomikosConnectionFactoryBean cannot be null.");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": initializing with [ xaConnectionFactory=" + this.xaConnectionFactory + ", xaConnectionFactoryClassName=" + this.xaConnectionFactoryClassName + ", uniqueResourceName=" + this.getUniqueResourceName() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minPoolSize=" + this.getMinPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", xaProperties=" + PropertyUtils.toString(this.xaProperties) + ", localTransactionMode=" + this.localTransactionMode + ", maxLifetime=" + this.maxLifetime + ", enableConcurrentConnectionValidation=" + this.enableConcurrentConnectionValidation + ", sessionCreationMode=" + this.sessionCreationMode + "]");
        }
        if (this.xaConnectionFactory == null) {
            try {
                Class xaClass = ClassLoadingHelper.loadClass(this.xaConnectionFactoryClassName);
                this.xaConnectionFactory = (XAConnectionFactory)xaClass.newInstance();
            }
            catch (ClassNotFoundException notFound) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean could not be found in the classpath. Please make sure the spelling in your setup is correct, and that the required jar(s) are in the classpath.", notFound);
            }
            catch (ClassCastException cce) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean does not implement the required interface javax.jms.XAConnectionFactory. Please make sure the spelling in your setup is correct, and check your JMS driver vendor's documentation.");
            }
            PropertyUtils.setProperties(this.xaConnectionFactory, this.xaProperties);
        }
        JmsTransactionalResource tr = new JmsTransactionalResource(this.getUniqueResourceName(), this.xaConnectionFactory);
        AtomikosJmsXAConnectionFactory cf = new AtomikosJmsXAConnectionFactory(this.xaConnectionFactory, tr, this);
        Configuration.addResource(tr);
        return cf;
    }

    @Override
    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    @Override
    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    @Override
    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public String getTestQuery() {
        return null;
    }

    public void setBorrowConnectionTimeout(int timeout) {
        this.borrowConnectionTimeout = timeout;
    }

    public void setMaintenanceInterval(int interval) {
        this.maintenanceInterval = interval;
    }

    public void setMaxIdleTime(int time) {
        this.maxIdleTime = time;
    }

    @Override
    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    public void setLocalTransactionMode(boolean mode) {
        this.localTransactionMode = mode;
    }

    @Override
    public int getDefaultIsolationLevel() {
        return -1;
    }

    @Override
    public synchronized void close() {
        block6: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logInfo(this + ": close...");
            }
            if (this.connectionPool != null) {
                this.connectionPool.destroy();
                this.connectionPool = null;
            }
            try {
                IntraVmObjectRegistry.removeResource(this.getUniqueResourceName());
            }
            catch (NameNotFoundException e) {
                if (!LOGGER.isTraceEnabled()) break block6;
                LOGGER.logTrace(this + ": error removing from JNDI", e);
            }
        }
        RecoverableResource res = Configuration.getResource(this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource(this.getUniqueResourceName());
            res.close();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": close done.");
        }
    }

    public String toString() {
        return this.getUniqueResourceName();
    }

    public Connection createConnection() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": createConnection()...");
        }
        Connection ret = null;
        try {
            this.init();
            ret = this.connectionPool.borrowConnection();
        }
        catch (CreateConnectionException ex) {
            this.throwAtomikosJMSException("Failed to create a connection", ex);
        }
        catch (PoolExhaustedException e) {
            this.throwAtomikosJMSException("Connection pool exhausted - try increasing 'maxPoolSize' and/or 'borrowConnectionTimeout' on the AtomikosConnectionFactoryBean.", e);
        }
        catch (ConnectionPoolException e) {
            this.throwAtomikosJMSException("Error borrowing connection", e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": createConnection() returning " + ret);
        }
        return ret;
    }

    public Connection createConnection(String user, String password) throws JMSException {
        LOGGER.logWarning(this + ": createConnection ( user , password ) ignores authentication - returning default connection");
        return this.createConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ret = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getReference()...");
        }
        ret = IntraVmObjectFactory.createReference(this, this.getUniqueResourceName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getReference() returning " + ret);
        }
        return ret;
    }

    public int poolAvailableSize() {
        return this.connectionPool.availableSize();
    }

    public int poolTotalSize() {
        return this.connectionPool.totalSize();
    }

    public void refreshPool() {
        if (this.connectionPool != null) {
            this.connectionPool.refresh();
        }
    }

    public boolean getIgnoreSessionTransactedFlag() {
        return this.sessionCreationMode != SessionCreationMode.PRE_3_9;
    }

    @Deprecated
    public void setIgnoreSessionTransactedFlag(boolean value) {
        this.sessionCreationMode = !value ? SessionCreationMode.PRE_3_9 : SessionCreationMode.JMS_2_0;
    }

    public void setConcurrentConnectionValidation(boolean value) {
        this.enableConcurrentConnectionValidation = value;
    }

    public boolean getConcurrentConnectionValidation() {
        return this.enableConcurrentConnectionValidation;
    }

    public JMSContext createContext() {
        throw new UnsupportedOperationException();
    }

    public JMSContext createContext(String userName, String password) {
        throw new UnsupportedOperationException();
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        throw new UnsupportedOperationException();
    }

    public JMSContext createContext(int sessionMode) {
        throw new UnsupportedOperationException();
    }

    public int getSessionCreationMode() {
        return this.sessionCreationMode;
    }

    public void setSessionCreationMode(int mode) {
        SessionCreationMode.assertValidityOf(mode);
        this.sessionCreationMode = mode;
    }

    private static class AtomikosJmsXAConnectionFactory
    implements com.atomikos.datasource.pool.ConnectionFactory<Connection> {
        private final XAConnectionFactory xaConnectionFactory;
        private final JmsTransactionalResource jmsTransactionalResource;
        private final AtomikosConnectionFactoryBean atomikosConnectionFactory;

        private AtomikosJmsXAConnectionFactory(XAConnectionFactory xaConnectionFactory, JmsTransactionalResource jmsTransactionalResource, AtomikosConnectionFactoryBean atomikosConnectionFactory) {
            this.xaConnectionFactory = xaConnectionFactory;
            this.jmsTransactionalResource = jmsTransactionalResource;
            this.atomikosConnectionFactory = atomikosConnectionFactory;
        }

        @Override
        public XPooledConnection<Connection> createPooledConnection() throws CreateConnectionException {
            try {
                XAConnection xac = this.xaConnectionFactory.createXAConnection();
                return new AtomikosPooledJmsConnection(this.atomikosConnectionFactory.getSessionCreationMode(), xac, this.jmsTransactionalResource, this.atomikosConnectionFactory);
            }
            catch (JMSException ex) {
                throw new CreateConnectionException("error creating JMS connection", (Exception)((Object)ex));
            }
        }
    }
}

