/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.AbstractCompositeTransaction;
import com.atomikos.icatch.imp.CompositeTerminatorImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ExtentImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.icatch.imp.TxActiveStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import com.atomikos.icatch.system.Configuration;
import java.util.Stack;

public class CompositeTransactionImp
extends AbstractCompositeTransaction
implements TransactionControl,
FSMEnterListener {
    protected CoordinatorImp coordinator_ = null;
    protected TransactionServiceImp txservice_;
    protected Extent extent_ = null;
    protected boolean localRoot_;
    private TransactionStateHandler stateHandler_;

    CompositeTransactionImp(Stack lineage, String tid, boolean serial, CoordinatorImp coordinator) {
        this(null, lineage, tid, serial, coordinator);
    }

    public CompositeTransactionImp(TransactionServiceImp txservice, Stack lineage, String tid, boolean serial, CoordinatorImp coordinator) throws IllegalStateException {
        super(tid, lineage, serial);
        this.coordinator_ = coordinator;
        this.txservice_ = txservice;
        this.extent_ = null;
        this.localRoot_ = true;
        this.stateHandler_ = new TxActiveStateHandler(this);
        coordinator.addFSMEnterListener(this, TxState.TERMINATED);
    }

    synchronized void localSetTransactionStateHandler(TransactionStateHandler handler) {
        this.stateHandler_ = handler;
    }

    synchronized void localTestAndSetTransactionStateHandler(TransactionStateHandler expected, TransactionStateHandler newHandler) {
        if (this.stateHandler_ != expected) {
            throw new IllegalStateException("State is no longer " + expected.getState() + " but " + newHandler.getState());
        }
        this.localSetTransactionStateHandler(newHandler);
    }

    synchronized TransactionStateHandler localGetTransactionStateHandler() {
        return this.stateHandler_;
    }

    boolean isLocalRoot() {
        return this.localRoot_;
    }

    TransactionServiceImp getTransactionService() {
        return this.txservice_;
    }

    CoordinatorImp getCoordinatorImp() {
        return this.coordinator_;
    }

    private void printMsg(String msg, int level) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(msg, level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TransactionControl getTransactionControl() {
        return this;
    }

    public int getLocalSubTxCount() {
        return this.localGetTransactionStateHandler().getSubTransactionCount();
    }

    public synchronized void setSerial() throws IllegalStateException, SysException {
        if (!this.isRoot()) {
            throw new IllegalStateException("setSerial() not allowed: not root tx.");
        }
        this.serial_ = true;
    }

    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction ret = this.localGetTransactionStateHandler().createSubTransaction();
        this.printMsg("createSubTransaction(): created new SUBTRANSACTION " + ret.getTid() + " for existing transaction " + this.getTid(), 2);
        return ret;
    }

    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        RecoveryCoordinator ret = this.localGetTransactionStateHandler().addParticipant(participant);
        this.printMsg("addParticipant ( " + participant + " ) for transaction " + this.getTid(), 2);
        return ret;
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        this.localGetTransactionStateHandler().registerSynchronization(sync);
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, IllegalStateException {
        this.localGetTransactionStateHandler().addSubTxAwareParticipant(subtxaware);
    }

    protected void doRollback() throws IllegalStateException, SysException {
        this.localGetTransactionStateHandler().rollbackWithStateCheck();
        this.printMsg("rollback() done of transaction " + this.getTid(), 2);
    }

    public CompositeCoordinator getCompositeCoordinator() throws SysException {
        return this.coordinator_;
    }

    public boolean isLocal() {
        return true;
    }

    public CompositeTerminator getTerminator() {
        return new CompositeTerminatorImp(this.txservice_, this, this.coordinator_);
    }

    protected void doCommit() throws SysException, IllegalStateException, RollbackException {
        this.localGetTransactionStateHandler().commit();
        this.printMsg("commit() done (by application) of transaction " + this.getTid(), 2);
    }

    public long getTimeout() {
        return this.coordinator_.getTimeOut();
    }

    public synchronized Extent getExtent() {
        if (this.extent_ == null) {
            this.extent_ = new ExtentImp();
        }
        return this.extent_;
    }

    public void setRollbackOnly() {
        this.localGetTransactionStateHandler().setRollbackOnly();
        this.printMsg("setRollbackOnly() called for transaction " + this.getTid(), 2);
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        this.getTerminator().commit();
    }

    public void rollback() throws IllegalStateException, SysException {
        this.getTerminator().rollback();
    }

    public Object getState() {
        return this.localGetTransactionStateHandler().getState();
    }

    public void entered(FSMEnterEvent event) {
        if (this.getState().equals(TxState.ACTIVE) || this.getState().equals(TxState.MARKED_ABORT)) {
            try {
                boolean recoverableWhileActive = false;
                Boolean pref = this.coordinator_.isRecoverableWhileActive();
                if (pref != null) {
                    recoverableWhileActive = pref;
                }
                if (!recoverableWhileActive && !(this.stateHandler_ instanceof TxTerminatedStateHandler)) {
                    this.setRollbackOnly();
                } else {
                    this.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

