/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.system;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxCode;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.icatch.system.Waiter;

public class SubTxThread
extends Thread {
    private SubTxCode myCode;
    private Waiter myWaiter;
    private Exception myException;
    private CompositeTransaction parent = Configuration.getCompositeTransactionManager().getCompositeTransaction();
    private Propagation propagation;
    private HeuristicMessage msg;

    public SubTxThread(Waiter w, SubTxCode code, HeuristicMessage tag) throws SysException {
        this.msg = tag;
        try {
            this.propagation = Configuration.getExportingTransactionManager().getPropagation();
        }
        catch (RollbackException e) {
            throw new SysException("Transaction already rolled back");
        }
        this.myWaiter = w;
        this.myWaiter.incActives();
        this.myCode = code;
        this.myException = null;
    }

    public Exception getException() {
        return this.myException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CompositeTransaction ct = null;
        try {
            ct = Configuration.getImportingTransactionManager().importTransaction(this.propagation, true, false);
            ct.getTransactionControl().setTag(this.msg);
            if (this.propagation.isSerial()) {
                this.myWaiter.getToken();
            }
            this.myCode.exec();
            ct.getTransactionControl().getTerminator().commit();
        }
        catch (Exception e) {
            this.myWaiter.incAbortCount();
            this.myException = e;
            ct.getTransactionControl().getTerminator().rollback();
        }
        finally {
            if (this.propagation.isSerial()) {
                this.myWaiter.giveToken();
            }
            this.myWaiter.decActives();
        }
    }
}

