/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateObjectImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class VolatileStateRecoveryManager
implements StateRecoveryManager,
FSMPreEnterListener {
    private Map idToElementMap = new HashMap();

    public void init() throws LogException {
    }

    public void register(StateRecoverable staterecoverable) {
        if (staterecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        Object[] states = staterecoverable.getRecoverableStates();
        if (states != null) {
            int i;
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
            states = staterecoverable.getFinalStates();
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
        }
    }

    public synchronized void preEnter(FSMEnterEvent event) throws IllegalStateException {
        Object state = event.getState();
        StateRecoverable source = (StateRecoverable)event.getSource();
        ObjectImage img = source.getObjectImage(state);
        if (img != null) {
            StateObjectImage simg = new StateObjectImage(img);
            Object[] finalstates = source.getFinalStates();
            boolean delete = false;
            for (int i = 0; i < finalstates.length; ++i) {
                if (!state.equals(finalstates[i])) continue;
                delete = true;
            }
            if (!delete) {
                this.idToElementMap.put(simg.getId(), simg);
            } else {
                this.idToElementMap.remove(simg.getId());
            }
        }
    }

    public void close() throws LogException {
    }

    public StateRecoverable recover(Object id) throws LogException {
        StateRecoverable ret = null;
        StateObjectImage simg = (StateObjectImage)this.idToElementMap.get(id);
        ret = (StateRecoverable)simg.restore();
        return ret;
    }

    public Vector recover() throws LogException {
        Vector<Recoverable> ret = new Vector<Recoverable>();
        Iterator keys = this.idToElementMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            StateObjectImage simg = (StateObjectImage)this.idToElementMap.get(key);
            ret.add(simg.restore());
        }
        return ret;
    }

    public synchronized void delete(Object id) throws LogException {
        this.idToElementMap.remove(id);
    }
}

