/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.destroyer;

import com.baomidou.dynamic.datasource.destroyer.DataSourceActiveDetector;
import javax.sql.DataSource;

public class HikariDataSourceActiveDetector
implements DataSourceActiveDetector {
    @Override
    public boolean containsActiveConnection(DataSource dataSource) {
        Object hikariPoolMXBean = dataSource.getClass().getMethod("getHikariPoolMXBean", new Class[0]).invoke((Object)dataSource, new Object[0]);
        int activeCount = null == hikariPoolMXBean ? 0 : (Integer)hikariPoolMXBean.getClass().getMethod("getActiveConnections", new Class[0]).invoke(hikariPoolMXBean, new Object[0]);
        return activeCount != 0;
    }

    @Override
    public boolean support(DataSource dataSource) {
        return "com.zaxxer.hikari.HikariDataSource".equals(dataSource.getClass().getName());
    }
}

