/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.annotation;

public enum DbType {
    MYSQL("mysql", "MySql\u6570\u636e\u5e93"),
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93"),
    ORACLE("oracle", "Oracle11g\u53ca\u4ee5\u4e0b\u6570\u636e\u5e93(\u9ad8\u7248\u672c\u63a8\u8350\u4f7f\u7528ORACLE_NEW)"),
    ORACLE_12C("oracle12c", "Oracle12c+\u6570\u636e\u5e93"),
    DB2("db2", "DB2\u6570\u636e\u5e93"),
    H2("h2", "H2\u6570\u636e\u5e93"),
    HSQL("hsql", "HSQL\u6570\u636e\u5e93"),
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93"),
    POSTGRE_SQL("postgresql", "Postgre\u6570\u636e\u5e93"),
    SQL_SERVER2005("sqlserver2005", "SQLServer2005\u6570\u636e\u5e93"),
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93"),
    DM("dm", "\u8fbe\u68a6\u6570\u636e\u5e93"),
    XU_GU("xugu", "\u865a\u8c37\u6570\u636e\u5e93"),
    KINGBASE_ES("kingbasees", "\u4eba\u5927\u91d1\u4ed3\u6570\u636e\u5e93"),
    PHOENIX("phoenix", "Phoenix HBase\u6570\u636e\u5e93"),
    GAUSS("zenith", "Gauss \u6570\u636e\u5e93"),
    CLICK_HOUSE("clickhouse", "clickhouse \u6570\u636e\u5e93"),
    GBASE("gbase", "\u5357\u5927\u901a\u7528(\u534e\u5e93)\u6570\u636e\u5e93"),
    GBASE_8S("gbase-8s", "\u5357\u5927\u901a\u7528\u6570\u636e\u5e93 GBase 8s"),
    GBASEDBT("gbasedbt", "\u5357\u5927\u901a\u7528\u6570\u636e\u5e93"),
    GBASE_INFORMIX("gbase 8s", "\u5357\u5927\u901a\u7528\u6570\u636e\u5e93 GBase 8s"),
    GBASE8S_PG("gbase8s-pg", "\u5357\u5927\u901a\u7528\u6570\u636e\u5e93 GBase 8s\u517c\u5bb9pg"),
    GBASE_8C("gbase8c", "\u5357\u5927\u901a\u7528\u6570\u636e\u5e93 GBase 8c"),
    SINODB("sinodb", "\u661f\u745e\u683c\u6570\u636e\u5e93"),
    OSCAR("oscar", "\u795e\u901a\u6570\u636e\u5e93"),
    SYBASE("sybase", "Sybase ASE \u6570\u636e\u5e93"),
    OCEAN_BASE("oceanbase", "OceanBase \u6570\u636e\u5e93"),
    FIREBIRD("Firebird", "Firebird \u6570\u636e\u5e93"),
    HIGH_GO("highgo", "\u701a\u9ad8\u6570\u636e\u5e93"),
    CUBRID("cubrid", "CUBRID\u6570\u636e\u5e93"),
    SUNDB("sundb", "SUNDB\u6570\u636e\u5e93"),
    SAP_HANA("hana", "SAP_HANA\u6570\u636e\u5e93"),
    IMPALA("impala", "impala\u6570\u636e\u5e93"),
    VERTICA("vertica", "vertica\u6570\u636e\u5e93"),
    XCloud("xcloud", "\u884c\u4e91\u6570\u636e\u5e93"),
    REDSHIFT("redshift", "\u4e9a\u9a6c\u900aredshift\u6570\u636e\u5e93"),
    OPENGAUSS("openGauss", "\u534e\u4e3a opengauss \u6570\u636e\u5e93"),
    TDENGINE("TDengine", "TDengine\u6570\u636e\u5e93"),
    INFORMIX("informix", "Informix\u6570\u636e\u5e93"),
    UXDB("uxdb", "\u4f18\u70ab\u6570\u636e\u5e93"),
    LEALONE("lealone", "Lealone\u6570\u636e\u5e93"),
    TRINO("trino", "Trino\u6570\u636e\u5e93"),
    PRESTO("presto", "Presto\u6570\u636e\u5e93"),
    OTHER("other", "\u5176\u4ed6\u6570\u636e\u5e93");

    private final String db;
    private final String desc;

    public static DbType getDbType(String dbType) {
        for (DbType type : DbType.values()) {
            if (!type.db.equalsIgnoreCase(dbType)) continue;
            return type;
        }
        return OTHER;
    }

    public boolean mysqlSameType() {
        return this == MYSQL || this == MARIADB || this == GBASE || this == OSCAR || this == XU_GU || this == CLICK_HOUSE || this == OCEAN_BASE || this == CUBRID || this == SUNDB;
    }

    public boolean oracleSameType() {
        return this == ORACLE || this == DM || this == GAUSS;
    }

    public boolean postgresqlSameType() {
        return this == POSTGRE_SQL || this == H2 || this == LEALONE || this == SQLITE || this == HSQL || this == KINGBASE_ES || this == PHOENIX || this == SAP_HANA || this == IMPALA || this == HIGH_GO || this == VERTICA || this == REDSHIFT || this == OPENGAUSS || this == TDENGINE || this == UXDB || this == GBASE8S_PG || this == GBASE_8C;
    }

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }

    private DbType(String db, String desc) {
        this.db = db;
        this.desc = desc;
    }
}

