/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IdentifierGeneratorAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={InetUtils.class})
    public static class InetUtilsAutoConfig {
        private final InetUtils inetUtils;
        private final MybatisPlusProperties properties;

        public InetUtilsAutoConfig(InetUtils inetUtils, MybatisPlusProperties properties) {
            this.inetUtils = inetUtils;
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean
        public IdentifierGenerator identifierGenerator() {
            GlobalConfig globalConfig = this.properties.getGlobalConfig();
            Long workerId = globalConfig.getWorkerId();
            Long datacenterId = globalConfig.getDatacenterId();
            if (workerId != null && datacenterId != null) {
                return new DefaultIdentifierGenerator(workerId.longValue(), datacenterId.longValue());
            }
            return new DefaultIdentifierGenerator(this.inetUtils.findFirstNonLoopbackAddress());
        }
    }
}

