/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.incrementer;

import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.imadcn.framework.idworker.config.ApplicationConfiguration;
import com.imadcn.framework.idworker.config.ZookeeperConfiguration;
import com.imadcn.framework.idworker.generator.CompressUUIDGenerator;
import com.imadcn.framework.idworker.generator.SnowflakeGenerator;
import com.imadcn.framework.idworker.register.zookeeper.ZookeeperWorkerRegister;
import com.imadcn.framework.idworker.registry.CoordinatorRegistryCenter;
import com.imadcn.framework.idworker.registry.zookeeper.ZookeeperRegistryCenter;
import java.io.Closeable;
import java.io.IOException;

public class ImadcnIdentifierGenerator
implements IdentifierGenerator,
Closeable {
    private final SnowflakeGenerator idGenerator;
    private final CompressUUIDGenerator uuidGenerator = new CompressUUIDGenerator();

    public ImadcnIdentifierGenerator(String serverLists) {
        this(ImadcnIdentifierGenerator.configuration(serverLists));
    }

    public ImadcnIdentifierGenerator(ZookeeperConfiguration zookeeperConfiguration) {
        this(zookeeperConfiguration, new ApplicationConfiguration());
    }

    public ImadcnIdentifierGenerator(ZookeeperConfiguration zookeeperConfiguration, ApplicationConfiguration applicationConfiguration) {
        ZookeeperRegistryCenter center = new ZookeeperRegistryCenter(zookeeperConfiguration);
        ZookeeperWorkerRegister register = new ZookeeperWorkerRegister((CoordinatorRegistryCenter)center, applicationConfiguration);
        this.idGenerator = new SnowflakeGenerator(register);
        this.idGenerator.init();
    }

    private static ZookeeperConfiguration configuration(String serverLists) {
        ZookeeperConfiguration zookeeperConfiguration = new ZookeeperConfiguration();
        zookeeperConfiguration.setServerLists(serverLists);
        return zookeeperConfiguration;
    }

    @Override
    public Number nextId(Object entity) {
        return this.idGenerator.nextId();
    }

    @Override
    public String nextUUID(Object entity) {
        return this.uuidGenerator.nextStringId();
    }

    @Override
    public void close() throws IOException {
        this.idGenerator.close();
    }
}

